/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ioteventsdata.DefaultIotEventsDataBaseClientBuilder;
import software.amazon.awssdk.services.ioteventsdata.DefaultIotEventsDataClient;
import software.amazon.awssdk.services.ioteventsdata.IotEventsDataClient;
import software.amazon.awssdk.services.ioteventsdata.IotEventsDataClientBuilder;
import software.amazon.awssdk.services.ioteventsdata.IotEventsDataServiceClientConfiguration;
import software.amazon.awssdk.services.ioteventsdata.endpoints.IotEventsDataEndpointProvider;

@SdkInternalApi
final class DefaultIotEventsDataClientBuilder
extends DefaultIotEventsDataBaseClientBuilder<IotEventsDataClientBuilder, IotEventsDataClient>
implements IotEventsDataClientBuilder {
    DefaultIotEventsDataClientBuilder() {
    }

    @Override
    public DefaultIotEventsDataClientBuilder endpointProvider(IotEventsDataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotEventsDataClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIotEventsDataClientBuilder.validateClientOptions(clientConfiguration);
        IotEventsDataServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIotEventsDataClient client = new DefaultIotEventsDataClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IotEventsDataServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IotEventsDataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

