/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.AlarmAction;
import software.amazon.awssdk.services.iotevents.model.AlarmActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmEventActions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmEventActions> {
    private static final SdkField<List<AlarmAction>> ALARM_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("alarmActions").getter(AlarmEventActions.getter(AlarmEventActions::alarmActions)).setter(AlarmEventActions.setter(Builder::alarmActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AlarmAction> alarmActions;

    private AlarmEventActions(BuilderImpl builder) {
        this.alarmActions = builder.alarmActions;
    }

    public final boolean hasAlarmActions() {
        return this.alarmActions != null && !(this.alarmActions instanceof SdkAutoConstructList);
    }

    public final List<AlarmAction> alarmActions() {
        return this.alarmActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmActions() ? this.alarmActions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmEventActions)) {
            return false;
        }
        AlarmEventActions other = (AlarmEventActions)obj;
        return this.hasAlarmActions() == other.hasAlarmActions() && Objects.equals(this.alarmActions(), other.alarmActions());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmEventActions").add("AlarmActions", this.hasAlarmActions() ? this.alarmActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmActions": {
                return Optional.ofNullable(clazz.cast(this.alarmActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmEventActions, T> g) {
        return obj -> g.apply((AlarmEventActions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AlarmAction> alarmActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmEventActions model) {
            this.alarmActions(model.alarmActions);
        }

        public final List<AlarmAction.Builder> getAlarmActions() {
            List<AlarmAction.Builder> result = AlarmActionsCopier.copyToBuilder(this.alarmActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarmActions(Collection<AlarmAction.BuilderImpl> alarmActions) {
            this.alarmActions = AlarmActionsCopier.copyFromBuilder(alarmActions);
        }

        @Override
        public final Builder alarmActions(Collection<AlarmAction> alarmActions) {
            this.alarmActions = AlarmActionsCopier.copy(alarmActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(AlarmAction ... alarmActions) {
            this.alarmActions(Arrays.asList(alarmActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmActions(Consumer<AlarmAction.Builder> ... alarmActions) {
            this.alarmActions(Stream.of(alarmActions).map(c -> (AlarmAction)((AlarmAction.Builder)AlarmAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AlarmEventActions build() {
            return new AlarmEventActions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmEventActions> {
        public Builder alarmActions(Collection<AlarmAction> var1);

        public Builder alarmActions(AlarmAction ... var1);

        public Builder alarmActions(Consumer<AlarmAction.Builder> ... var1);
    }
}

