/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInputRoutingsResponse extends IotEventsResponse implements
        ToCopyableBuilder<ListInputRoutingsResponse.Builder, ListInputRoutingsResponse> {
    private static final SdkField<List<RoutedResource>> ROUTED_RESOURCES_FIELD = SdkField
            .<List<RoutedResource>> builder(MarshallingType.LIST)
            .memberName("routedResources")
            .getter(getter(ListInputRoutingsResponse::routedResources))
            .setter(setter(Builder::routedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutedResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutedResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListInputRoutingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTED_RESOURCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RoutedResource> routedResources;

    private final String nextToken;

    private ListInputRoutingsResponse(BuilderImpl builder) {
        super(builder);
        this.routedResources = builder.routedResources;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutedResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutedResources() {
        return routedResources != null && !(routedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the routed resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutedResources} method.
     * </p>
     * 
     * @return Summary information about the routed resources.
     */
    public final List<RoutedResource> routedResources() {
        return routedResources;
    }

    /**
     * <p>
     * The token that you can use to return the next set of results, or <code>null</code> if there are no more results.
     * </p>
     * 
     * @return The token that you can use to return the next set of results, or <code>null</code> if there are no more
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutedResources() ? routedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInputRoutingsResponse)) {
            return false;
        }
        ListInputRoutingsResponse other = (ListInputRoutingsResponse) obj;
        return hasRoutedResources() == other.hasRoutedResources() && Objects.equals(routedResources(), other.routedResources())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInputRoutingsResponse")
                .add("RoutedResources", hasRoutedResources() ? routedResources() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "routedResources":
            return Optional.ofNullable(clazz.cast(routedResources()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInputRoutingsResponse, T> g) {
        return obj -> g.apply((ListInputRoutingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInputRoutingsResponse> {
        /**
         * <p>
         * Summary information about the routed resources.
         * </p>
         * 
         * @param routedResources
         *        Summary information about the routed resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routedResources(Collection<RoutedResource> routedResources);

        /**
         * <p>
         * Summary information about the routed resources.
         * </p>
         * 
         * @param routedResources
         *        Summary information about the routed resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routedResources(RoutedResource... routedResources);

        /**
         * <p>
         * Summary information about the routed resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotevents.model.RoutedResource.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotevents.model.RoutedResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotevents.model.RoutedResource.Builder#build()} is called immediately
         * and its result is passed to {@link #routedResources(List<RoutedResource>)}.
         * 
         * @param routedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotevents.model.RoutedResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routedResources(java.util.Collection<RoutedResource>)
         */
        Builder routedResources(Consumer<RoutedResource.Builder>... routedResources);

        /**
         * <p>
         * The token that you can use to return the next set of results, or <code>null</code> if there are no more
         * results.
         * </p>
         * 
         * @param nextToken
         *        The token that you can use to return the next set of results, or <code>null</code> if there are no
         *        more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotEventsResponse.BuilderImpl implements Builder {
        private List<RoutedResource> routedResources = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInputRoutingsResponse model) {
            super(model);
            routedResources(model.routedResources);
            nextToken(model.nextToken);
        }

        public final List<RoutedResource.Builder> getRoutedResources() {
            List<RoutedResource.Builder> result = RoutedResourcesCopier.copyToBuilder(this.routedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutedResources(Collection<RoutedResource.BuilderImpl> routedResources) {
            this.routedResources = RoutedResourcesCopier.copyFromBuilder(routedResources);
        }

        @Override
        public final Builder routedResources(Collection<RoutedResource> routedResources) {
            this.routedResources = RoutedResourcesCopier.copy(routedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routedResources(RoutedResource... routedResources) {
            routedResources(Arrays.asList(routedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routedResources(Consumer<RoutedResource.Builder>... routedResources) {
            routedResources(Stream.of(routedResources).map(c -> RoutedResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInputRoutingsResponse build() {
            return new ListInputRoutingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
