/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAlarmModelRequest extends IotEventsRequest implements
        ToCopyableBuilder<DeleteAlarmModelRequest.Builder, DeleteAlarmModelRequest> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelName").getter(getter(DeleteAlarmModelRequest::alarmModelName))
            .setter(setter(Builder::alarmModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("alarmModelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD));

    private final String alarmModelName;

    private DeleteAlarmModelRequest(BuilderImpl builder) {
        super(builder);
        this.alarmModelName = builder.alarmModelName;
    }

    /**
     * <p>
     * The name of the alarm model.
     * </p>
     * 
     * @return The name of the alarm model.
     */
    public final String alarmModelName() {
        return alarmModelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAlarmModelRequest)) {
            return false;
        }
        DeleteAlarmModelRequest other = (DeleteAlarmModelRequest) obj;
        return Objects.equals(alarmModelName(), other.alarmModelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAlarmModelRequest").add("AlarmModelName", alarmModelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmModelName":
            return Optional.ofNullable(clazz.cast(alarmModelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAlarmModelRequest, T> g) {
        return obj -> g.apply((DeleteAlarmModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAlarmModelRequest> {
        /**
         * <p>
         * The name of the alarm model.
         * </p>
         * 
         * @param alarmModelName
         *        The name of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelName(String alarmModelName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsRequest.BuilderImpl implements Builder {
        private String alarmModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAlarmModelRequest model) {
            super(model);
            alarmModelName(model.alarmModelName);
        }

        public final String getAlarmModelName() {
            return alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAlarmModelRequest build() {
            return new DeleteAlarmModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
