/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to
 * the AWS IoT Events system using <code>BatchPutMessage</code>. Each such message contains a JSON payload. Those
 * attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions
 * used by detectors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attribute implements SdkPojo, Serializable, ToCopyableBuilder<Attribute.Builder, Attribute> {
    private static final SdkField<String> JSON_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jsonPath").getter(getter(Attribute::jsonPath)).setter(setter(Builder::jsonPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jsonPath;

    private Attribute(BuilderImpl builder) {
        this.jsonPath = builder.jsonPath;
    }

    /**
     * <p>
     * An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from
     * the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events (
     * <code>BatchPutMessage</code>). Each such message contains a JSON payload. The attribute (and its paired value)
     * specified here are available for use in the <code>condition</code> expressions used by detectors.
     * </p>
     * <p>
     * Syntax: <code>&lt;field-name&gt;.&lt;field-name&gt;...</code>
     * </p>
     * 
     * @return An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an
     *         attribute from the JSON payload that is made available by the input. Inputs are derived from messages
     *         sent to AWS IoT Events (<code>BatchPutMessage</code>). Each such message contains a JSON payload. The
     *         attribute (and its paired value) specified here are available for use in the <code>condition</code>
     *         expressions used by detectors. </p>
     *         <p>
     *         Syntax: <code>&lt;field-name&gt;.&lt;field-name&gt;...</code>
     */
    public final String jsonPath() {
        return jsonPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jsonPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute) obj;
        return Objects.equals(jsonPath(), other.jsonPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attribute").add("JsonPath", jsonPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jsonPath":
            return Optional.ofNullable(clazz.cast(jsonPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Attribute, T> g) {
        return obj -> g.apply((Attribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attribute> {
        /**
         * <p>
         * An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute
         * from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT
         * Events (<code>BatchPutMessage</code>). Each such message contains a JSON payload. The attribute (and its
         * paired value) specified here are available for use in the <code>condition</code> expressions used by
         * detectors.
         * </p>
         * <p>
         * Syntax: <code>&lt;field-name&gt;.&lt;field-name&gt;...</code>
         * </p>
         * 
         * @param jsonPath
         *        An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an
         *        attribute from the JSON payload that is made available by the input. Inputs are derived from messages
         *        sent to AWS IoT Events (<code>BatchPutMessage</code>). Each such message contains a JSON payload. The
         *        attribute (and its paired value) specified here are available for use in the <code>condition</code>
         *        expressions used by detectors. </p>
         *        <p>
         *        Syntax: <code>&lt;field-name&gt;.&lt;field-name&gt;...</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonPath(String jsonPath);
    }

    static final class BuilderImpl implements Builder {
        private String jsonPath;

        private BuilderImpl() {
        }

        private BuilderImpl(Attribute model) {
            jsonPath(model.jsonPath);
        }

        public final String getJsonPath() {
            return jsonPath;
        }

        public final void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        @Override
        public final Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        @Override
        public Attribute build() {
            return new Attribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
