/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information of alarm state changes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlarmCapabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<AlarmCapabilities.Builder, AlarmCapabilities> {
    private static final SdkField<InitializationConfiguration> INITIALIZATION_CONFIGURATION_FIELD = SdkField
            .<InitializationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("initializationConfiguration")
            .getter(getter(AlarmCapabilities::initializationConfiguration))
            .setter(setter(Builder::initializationConfiguration))
            .constructor(InitializationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationConfiguration")
                    .build()).build();

    private static final SdkField<AcknowledgeFlow> ACKNOWLEDGE_FLOW_FIELD = SdkField
            .<AcknowledgeFlow> builder(MarshallingType.SDK_POJO).memberName("acknowledgeFlow")
            .getter(getter(AlarmCapabilities::acknowledgeFlow)).setter(setter(Builder::acknowledgeFlow))
            .constructor(AcknowledgeFlow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acknowledgeFlow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INITIALIZATION_CONFIGURATION_FIELD, ACKNOWLEDGE_FLOW_FIELD));

    private static final long serialVersionUID = 1L;

    private final InitializationConfiguration initializationConfiguration;

    private final AcknowledgeFlow acknowledgeFlow;

    private AlarmCapabilities(BuilderImpl builder) {
        this.initializationConfiguration = builder.initializationConfiguration;
        this.acknowledgeFlow = builder.acknowledgeFlow;
    }

    /**
     * <p>
     * Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm
     * model.
     * </p>
     * 
     * @return Specifies the default alarm state. The configuration applies to all alarms that were created based on
     *         this alarm model.
     */
    public final InitializationConfiguration initializationConfiguration() {
        return initializationConfiguration;
    }

    /**
     * <p>
     * Specifies whether to get notified for alarm state changes.
     * </p>
     * 
     * @return Specifies whether to get notified for alarm state changes.
     */
    public final AcknowledgeFlow acknowledgeFlow() {
        return acknowledgeFlow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initializationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(acknowledgeFlow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmCapabilities)) {
            return false;
        }
        AlarmCapabilities other = (AlarmCapabilities) obj;
        return Objects.equals(initializationConfiguration(), other.initializationConfiguration())
                && Objects.equals(acknowledgeFlow(), other.acknowledgeFlow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlarmCapabilities").add("InitializationConfiguration", initializationConfiguration())
                .add("AcknowledgeFlow", acknowledgeFlow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "initializationConfiguration":
            return Optional.ofNullable(clazz.cast(initializationConfiguration()));
        case "acknowledgeFlow":
            return Optional.ofNullable(clazz.cast(acknowledgeFlow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmCapabilities, T> g) {
        return obj -> g.apply((AlarmCapabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlarmCapabilities> {
        /**
         * <p>
         * Specifies the default alarm state. The configuration applies to all alarms that were created based on this
         * alarm model.
         * </p>
         * 
         * @param initializationConfiguration
         *        Specifies the default alarm state. The configuration applies to all alarms that were created based on
         *        this alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationConfiguration(InitializationConfiguration initializationConfiguration);

        /**
         * <p>
         * Specifies the default alarm state. The configuration applies to all alarms that were created based on this
         * alarm model.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitializationConfiguration.Builder}
         * avoiding the need to create one manually via {@link InitializationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitializationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #initializationConfiguration(InitializationConfiguration)}.
         * 
         * @param initializationConfiguration
         *        a consumer that will call methods on {@link InitializationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initializationConfiguration(InitializationConfiguration)
         */
        default Builder initializationConfiguration(Consumer<InitializationConfiguration.Builder> initializationConfiguration) {
            return initializationConfiguration(InitializationConfiguration.builder().applyMutation(initializationConfiguration)
                    .build());
        }

        /**
         * <p>
         * Specifies whether to get notified for alarm state changes.
         * </p>
         * 
         * @param acknowledgeFlow
         *        Specifies whether to get notified for alarm state changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acknowledgeFlow(AcknowledgeFlow acknowledgeFlow);

        /**
         * <p>
         * Specifies whether to get notified for alarm state changes.
         * </p>
         * This is a convenience method that creates an instance of the {@link AcknowledgeFlow.Builder} avoiding the
         * need to create one manually via {@link AcknowledgeFlow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AcknowledgeFlow.Builder#build()} is called immediately and its
         * result is passed to {@link #acknowledgeFlow(AcknowledgeFlow)}.
         * 
         * @param acknowledgeFlow
         *        a consumer that will call methods on {@link AcknowledgeFlow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acknowledgeFlow(AcknowledgeFlow)
         */
        default Builder acknowledgeFlow(Consumer<AcknowledgeFlow.Builder> acknowledgeFlow) {
            return acknowledgeFlow(AcknowledgeFlow.builder().applyMutation(acknowledgeFlow).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InitializationConfiguration initializationConfiguration;

        private AcknowledgeFlow acknowledgeFlow;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmCapabilities model) {
            initializationConfiguration(model.initializationConfiguration);
            acknowledgeFlow(model.acknowledgeFlow);
        }

        public final InitializationConfiguration.Builder getInitializationConfiguration() {
            return initializationConfiguration != null ? initializationConfiguration.toBuilder() : null;
        }

        public final void setInitializationConfiguration(InitializationConfiguration.BuilderImpl initializationConfiguration) {
            this.initializationConfiguration = initializationConfiguration != null ? initializationConfiguration.build() : null;
        }

        @Override
        public final Builder initializationConfiguration(InitializationConfiguration initializationConfiguration) {
            this.initializationConfiguration = initializationConfiguration;
            return this;
        }

        public final AcknowledgeFlow.Builder getAcknowledgeFlow() {
            return acknowledgeFlow != null ? acknowledgeFlow.toBuilder() : null;
        }

        public final void setAcknowledgeFlow(AcknowledgeFlow.BuilderImpl acknowledgeFlow) {
            this.acknowledgeFlow = acknowledgeFlow != null ? acknowledgeFlow.build() : null;
        }

        @Override
        public final Builder acknowledgeFlow(AcknowledgeFlow acknowledgeFlow) {
            this.acknowledgeFlow = acknowledgeFlow;
            return this;
        }

        @Override
        public AlarmCapabilities build() {
            return new AlarmCapabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
