/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An action to be performed when the <code>condition</code> is TRUE.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<SetVariableAction> SET_VARIABLE_FIELD = SdkField
            .<SetVariableAction> builder(MarshallingType.SDK_POJO).memberName("setVariable").getter(getter(Action::setVariable))
            .setter(setter(Builder::setVariable)).constructor(SetVariableAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setVariable").build()).build();

    private static final SdkField<SNSTopicPublishAction> SNS_FIELD = SdkField
            .<SNSTopicPublishAction> builder(MarshallingType.SDK_POJO).memberName("sns").getter(getter(Action::sns))
            .setter(setter(Builder::sns)).constructor(SNSTopicPublishAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sns").build()).build();

    private static final SdkField<IotTopicPublishAction> IOT_TOPIC_PUBLISH_FIELD = SdkField
            .<IotTopicPublishAction> builder(MarshallingType.SDK_POJO).memberName("iotTopicPublish")
            .getter(getter(Action::iotTopicPublish)).setter(setter(Builder::iotTopicPublish))
            .constructor(IotTopicPublishAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotTopicPublish").build()).build();

    private static final SdkField<SetTimerAction> SET_TIMER_FIELD = SdkField.<SetTimerAction> builder(MarshallingType.SDK_POJO)
            .memberName("setTimer").getter(getter(Action::setTimer)).setter(setter(Builder::setTimer))
            .constructor(SetTimerAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setTimer").build()).build();

    private static final SdkField<ClearTimerAction> CLEAR_TIMER_FIELD = SdkField
            .<ClearTimerAction> builder(MarshallingType.SDK_POJO).memberName("clearTimer").getter(getter(Action::clearTimer))
            .setter(setter(Builder::clearTimer)).constructor(ClearTimerAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clearTimer").build()).build();

    private static final SdkField<ResetTimerAction> RESET_TIMER_FIELD = SdkField
            .<ResetTimerAction> builder(MarshallingType.SDK_POJO).memberName("resetTimer").getter(getter(Action::resetTimer))
            .setter(setter(Builder::resetTimer)).constructor(ResetTimerAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resetTimer").build()).build();

    private static final SdkField<LambdaAction> LAMBDA_FIELD = SdkField.<LambdaAction> builder(MarshallingType.SDK_POJO)
            .memberName("lambda").getter(getter(Action::lambda)).setter(setter(Builder::lambda))
            .constructor(LambdaAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()).build();

    private static final SdkField<IotEventsAction> IOT_EVENTS_FIELD = SdkField
            .<IotEventsAction> builder(MarshallingType.SDK_POJO).memberName("iotEvents").getter(getter(Action::iotEvents))
            .setter(setter(Builder::iotEvents)).constructor(IotEventsAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotEvents").build()).build();

    private static final SdkField<SqsAction> SQS_FIELD = SdkField.<SqsAction> builder(MarshallingType.SDK_POJO).memberName("sqs")
            .getter(getter(Action::sqs)).setter(setter(Builder::sqs)).constructor(SqsAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqs").build()).build();

    private static final SdkField<FirehoseAction> FIREHOSE_FIELD = SdkField.<FirehoseAction> builder(MarshallingType.SDK_POJO)
            .memberName("firehose").getter(getter(Action::firehose)).setter(setter(Builder::firehose))
            .constructor(FirehoseAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()).build();

    private static final SdkField<DynamoDBAction> DYNAMO_DB_FIELD = SdkField.<DynamoDBAction> builder(MarshallingType.SDK_POJO)
            .memberName("dynamoDB").getter(getter(Action::dynamoDB)).setter(setter(Builder::dynamoDB))
            .constructor(DynamoDBAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamoDB").build()).build();

    private static final SdkField<DynamoDBv2Action> DYNAMO_DB_V2_FIELD = SdkField
            .<DynamoDBv2Action> builder(MarshallingType.SDK_POJO).memberName("dynamoDBv2").getter(getter(Action::dynamoDBv2))
            .setter(setter(Builder::dynamoDBv2)).constructor(DynamoDBv2Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamoDBv2").build()).build();

    private static final SdkField<IotSiteWiseAction> IOT_SITE_WISE_FIELD = SdkField
            .<IotSiteWiseAction> builder(MarshallingType.SDK_POJO).memberName("iotSiteWise").getter(getter(Action::iotSiteWise))
            .setter(setter(Builder::iotSiteWise)).constructor(IotSiteWiseAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWise").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SET_VARIABLE_FIELD, SNS_FIELD,
            IOT_TOPIC_PUBLISH_FIELD, SET_TIMER_FIELD, CLEAR_TIMER_FIELD, RESET_TIMER_FIELD, LAMBDA_FIELD, IOT_EVENTS_FIELD,
            SQS_FIELD, FIREHOSE_FIELD, DYNAMO_DB_FIELD, DYNAMO_DB_V2_FIELD, IOT_SITE_WISE_FIELD));

    private static final long serialVersionUID = 1L;

    private final SetVariableAction setVariable;

    private final SNSTopicPublishAction sns;

    private final IotTopicPublishAction iotTopicPublish;

    private final SetTimerAction setTimer;

    private final ClearTimerAction clearTimer;

    private final ResetTimerAction resetTimer;

    private final LambdaAction lambda;

    private final IotEventsAction iotEvents;

    private final SqsAction sqs;

    private final FirehoseAction firehose;

    private final DynamoDBAction dynamoDB;

    private final DynamoDBv2Action dynamoDBv2;

    private final IotSiteWiseAction iotSiteWise;

    private Action(BuilderImpl builder) {
        this.setVariable = builder.setVariable;
        this.sns = builder.sns;
        this.iotTopicPublish = builder.iotTopicPublish;
        this.setTimer = builder.setTimer;
        this.clearTimer = builder.clearTimer;
        this.resetTimer = builder.resetTimer;
        this.lambda = builder.lambda;
        this.iotEvents = builder.iotEvents;
        this.sqs = builder.sqs;
        this.firehose = builder.firehose;
        this.dynamoDB = builder.dynamoDB;
        this.dynamoDBv2 = builder.dynamoDBv2;
        this.iotSiteWise = builder.iotSiteWise;
    }

    /**
     * <p>
     * Sets a variable to a specified value.
     * </p>
     * 
     * @return Sets a variable to a specified value.
     */
    public final SetVariableAction setVariable() {
        return setVariable;
    }

    /**
     * <p>
     * Sends an Amazon SNS message.
     * </p>
     * 
     * @return Sends an Amazon SNS message.
     */
    public final SNSTopicPublishAction sns() {
        return sns;
    }

    /**
     * <p>
     * Publishes an MQTT message with the given topic to the AWS IoT message broker.
     * </p>
     * 
     * @return Publishes an MQTT message with the given topic to the AWS IoT message broker.
     */
    public final IotTopicPublishAction iotTopicPublish() {
        return iotTopicPublish;
    }

    /**
     * <p>
     * Information needed to set the timer.
     * </p>
     * 
     * @return Information needed to set the timer.
     */
    public final SetTimerAction setTimer() {
        return setTimer;
    }

    /**
     * <p>
     * Information needed to clear the timer.
     * </p>
     * 
     * @return Information needed to clear the timer.
     */
    public final ClearTimerAction clearTimer() {
        return clearTimer;
    }

    /**
     * <p>
     * Information needed to reset the timer.
     * </p>
     * 
     * @return Information needed to reset the timer.
     */
    public final ResetTimerAction resetTimer() {
        return resetTimer;
    }

    /**
     * <p>
     * Calls a Lambda function, passing in information about the detector model instance and the event that triggered
     * the action.
     * </p>
     * 
     * @return Calls a Lambda function, passing in information about the detector model instance and the event that
     *         triggered the action.
     */
    public final LambdaAction lambda() {
        return lambda;
    }

    /**
     * <p>
     * Sends AWS IoT Events input, which passes information about the detector model instance and the event that
     * triggered the action.
     * </p>
     * 
     * @return Sends AWS IoT Events input, which passes information about the detector model instance and the event that
     *         triggered the action.
     */
    public final IotEventsAction iotEvents() {
        return iotEvents;
    }

    /**
     * <p>
     * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS
     * queue.
     * </p>
     * 
     * @return Sends information about the detector model instance and the event that triggered the action to an Amazon
     *         SQS queue.
     */
    public final SqsAction sqs() {
        return sqs;
    }

    /**
     * <p>
     * Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis
     * Data Firehose delivery stream.
     * </p>
     * 
     * @return Sends information about the detector model instance and the event that triggered the action to an Amazon
     *         Kinesis Data Firehose delivery stream.
     */
    public final FirehoseAction firehose() {
        return firehose;
    }

    /**
     * <p>
     * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that
     * have the information about the detector model instance and the event that triggered the action. You can customize
     * the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column
     * of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in
     * <i>AWS IoT Events Developer Guide</i>.
     * </p>
     * 
     * @return Writes to the DynamoDB table that you created. The default action payload contains all attribute-value
     *         pairs that have the information about the detector model instance and the event that triggered the
     *         action. You can customize the <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column
     *         of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html"
     *         >Actions</a> in <i>AWS IoT Events Developer Guide</i>.
     */
    public final DynamoDBAction dynamoDB() {
        return dynamoDB;
    }

    /**
     * <p>
     * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that
     * have the information about the detector model instance and the event that triggered the action. You can customize
     * the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate
     * column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in
     * <i>AWS IoT Events Developer Guide</i>.
     * </p>
     * 
     * @return Writes to the DynamoDB table that you created. The default action payload contains all attribute-value
     *         pairs that have the information about the detector model instance and the event that triggered the
     *         action. You can customize the <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate
     *         column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html"
     *         >Actions</a> in <i>AWS IoT Events Developer Guide</i>.
     */
    public final DynamoDBv2Action dynamoDBv2() {
        return dynamoDBv2;
    }

    /**
     * <p>
     * Sends information about the detector model instance and the event that triggered the action to an asset property
     * in AWS IoT SiteWise .
     * </p>
     * 
     * @return Sends information about the detector model instance and the event that triggered the action to an asset
     *         property in AWS IoT SiteWise .
     */
    public final IotSiteWiseAction iotSiteWise() {
        return iotSiteWise;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(setVariable());
        hashCode = 31 * hashCode + Objects.hashCode(sns());
        hashCode = 31 * hashCode + Objects.hashCode(iotTopicPublish());
        hashCode = 31 * hashCode + Objects.hashCode(setTimer());
        hashCode = 31 * hashCode + Objects.hashCode(clearTimer());
        hashCode = 31 * hashCode + Objects.hashCode(resetTimer());
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        hashCode = 31 * hashCode + Objects.hashCode(iotEvents());
        hashCode = 31 * hashCode + Objects.hashCode(sqs());
        hashCode = 31 * hashCode + Objects.hashCode(firehose());
        hashCode = 31 * hashCode + Objects.hashCode(dynamoDB());
        hashCode = 31 * hashCode + Objects.hashCode(dynamoDBv2());
        hashCode = 31 * hashCode + Objects.hashCode(iotSiteWise());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(setVariable(), other.setVariable()) && Objects.equals(sns(), other.sns())
                && Objects.equals(iotTopicPublish(), other.iotTopicPublish()) && Objects.equals(setTimer(), other.setTimer())
                && Objects.equals(clearTimer(), other.clearTimer()) && Objects.equals(resetTimer(), other.resetTimer())
                && Objects.equals(lambda(), other.lambda()) && Objects.equals(iotEvents(), other.iotEvents())
                && Objects.equals(sqs(), other.sqs()) && Objects.equals(firehose(), other.firehose())
                && Objects.equals(dynamoDB(), other.dynamoDB()) && Objects.equals(dynamoDBv2(), other.dynamoDBv2())
                && Objects.equals(iotSiteWise(), other.iotSiteWise());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("SetVariable", setVariable()).add("Sns", sns())
                .add("IotTopicPublish", iotTopicPublish()).add("SetTimer", setTimer()).add("ClearTimer", clearTimer())
                .add("ResetTimer", resetTimer()).add("Lambda", lambda()).add("IotEvents", iotEvents()).add("Sqs", sqs())
                .add("Firehose", firehose()).add("DynamoDB", dynamoDB()).add("DynamoDBv2", dynamoDBv2())
                .add("IotSiteWise", iotSiteWise()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "setVariable":
            return Optional.ofNullable(clazz.cast(setVariable()));
        case "sns":
            return Optional.ofNullable(clazz.cast(sns()));
        case "iotTopicPublish":
            return Optional.ofNullable(clazz.cast(iotTopicPublish()));
        case "setTimer":
            return Optional.ofNullable(clazz.cast(setTimer()));
        case "clearTimer":
            return Optional.ofNullable(clazz.cast(clearTimer()));
        case "resetTimer":
            return Optional.ofNullable(clazz.cast(resetTimer()));
        case "lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        case "iotEvents":
            return Optional.ofNullable(clazz.cast(iotEvents()));
        case "sqs":
            return Optional.ofNullable(clazz.cast(sqs()));
        case "firehose":
            return Optional.ofNullable(clazz.cast(firehose()));
        case "dynamoDB":
            return Optional.ofNullable(clazz.cast(dynamoDB()));
        case "dynamoDBv2":
            return Optional.ofNullable(clazz.cast(dynamoDBv2()));
        case "iotSiteWise":
            return Optional.ofNullable(clazz.cast(iotSiteWise()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * Sets a variable to a specified value.
         * </p>
         * 
         * @param setVariable
         *        Sets a variable to a specified value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setVariable(SetVariableAction setVariable);

        /**
         * <p>
         * Sets a variable to a specified value.
         * </p>
         * This is a convenience method that creates an instance of the {@link SetVariableAction.Builder} avoiding the
         * need to create one manually via {@link SetVariableAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetVariableAction.Builder#build()} is called immediately and its
         * result is passed to {@link #setVariable(SetVariableAction)}.
         * 
         * @param setVariable
         *        a consumer that will call methods on {@link SetVariableAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #setVariable(SetVariableAction)
         */
        default Builder setVariable(Consumer<SetVariableAction.Builder> setVariable) {
            return setVariable(SetVariableAction.builder().applyMutation(setVariable).build());
        }

        /**
         * <p>
         * Sends an Amazon SNS message.
         * </p>
         * 
         * @param sns
         *        Sends an Amazon SNS message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sns(SNSTopicPublishAction sns);

        /**
         * <p>
         * Sends an Amazon SNS message.
         * </p>
         * This is a convenience method that creates an instance of the {@link SNSTopicPublishAction.Builder} avoiding
         * the need to create one manually via {@link SNSTopicPublishAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SNSTopicPublishAction.Builder#build()} is called immediately and
         * its result is passed to {@link #sns(SNSTopicPublishAction)}.
         * 
         * @param sns
         *        a consumer that will call methods on {@link SNSTopicPublishAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sns(SNSTopicPublishAction)
         */
        default Builder sns(Consumer<SNSTopicPublishAction.Builder> sns) {
            return sns(SNSTopicPublishAction.builder().applyMutation(sns).build());
        }

        /**
         * <p>
         * Publishes an MQTT message with the given topic to the AWS IoT message broker.
         * </p>
         * 
         * @param iotTopicPublish
         *        Publishes an MQTT message with the given topic to the AWS IoT message broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotTopicPublish(IotTopicPublishAction iotTopicPublish);

        /**
         * <p>
         * Publishes an MQTT message with the given topic to the AWS IoT message broker.
         * </p>
         * This is a convenience method that creates an instance of the {@link IotTopicPublishAction.Builder} avoiding
         * the need to create one manually via {@link IotTopicPublishAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IotTopicPublishAction.Builder#build()} is called immediately and
         * its result is passed to {@link #iotTopicPublish(IotTopicPublishAction)}.
         * 
         * @param iotTopicPublish
         *        a consumer that will call methods on {@link IotTopicPublishAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotTopicPublish(IotTopicPublishAction)
         */
        default Builder iotTopicPublish(Consumer<IotTopicPublishAction.Builder> iotTopicPublish) {
            return iotTopicPublish(IotTopicPublishAction.builder().applyMutation(iotTopicPublish).build());
        }

        /**
         * <p>
         * Information needed to set the timer.
         * </p>
         * 
         * @param setTimer
         *        Information needed to set the timer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setTimer(SetTimerAction setTimer);

        /**
         * <p>
         * Information needed to set the timer.
         * </p>
         * This is a convenience method that creates an instance of the {@link SetTimerAction.Builder} avoiding the need
         * to create one manually via {@link SetTimerAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SetTimerAction.Builder#build()} is called immediately and its
         * result is passed to {@link #setTimer(SetTimerAction)}.
         * 
         * @param setTimer
         *        a consumer that will call methods on {@link SetTimerAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #setTimer(SetTimerAction)
         */
        default Builder setTimer(Consumer<SetTimerAction.Builder> setTimer) {
            return setTimer(SetTimerAction.builder().applyMutation(setTimer).build());
        }

        /**
         * <p>
         * Information needed to clear the timer.
         * </p>
         * 
         * @param clearTimer
         *        Information needed to clear the timer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clearTimer(ClearTimerAction clearTimer);

        /**
         * <p>
         * Information needed to clear the timer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClearTimerAction.Builder} avoiding the
         * need to create one manually via {@link ClearTimerAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClearTimerAction.Builder#build()} is called immediately and its
         * result is passed to {@link #clearTimer(ClearTimerAction)}.
         * 
         * @param clearTimer
         *        a consumer that will call methods on {@link ClearTimerAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clearTimer(ClearTimerAction)
         */
        default Builder clearTimer(Consumer<ClearTimerAction.Builder> clearTimer) {
            return clearTimer(ClearTimerAction.builder().applyMutation(clearTimer).build());
        }

        /**
         * <p>
         * Information needed to reset the timer.
         * </p>
         * 
         * @param resetTimer
         *        Information needed to reset the timer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetTimer(ResetTimerAction resetTimer);

        /**
         * <p>
         * Information needed to reset the timer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResetTimerAction.Builder} avoiding the
         * need to create one manually via {@link ResetTimerAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResetTimerAction.Builder#build()} is called immediately and its
         * result is passed to {@link #resetTimer(ResetTimerAction)}.
         * 
         * @param resetTimer
         *        a consumer that will call methods on {@link ResetTimerAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resetTimer(ResetTimerAction)
         */
        default Builder resetTimer(Consumer<ResetTimerAction.Builder> resetTimer) {
            return resetTimer(ResetTimerAction.builder().applyMutation(resetTimer).build());
        }

        /**
         * <p>
         * Calls a Lambda function, passing in information about the detector model instance and the event that
         * triggered the action.
         * </p>
         * 
         * @param lambda
         *        Calls a Lambda function, passing in information about the detector model instance and the event that
         *        triggered the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(LambdaAction lambda);

        /**
         * <p>
         * Calls a Lambda function, passing in information about the detector model instance and the event that
         * triggered the action.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaAction.Builder} avoiding the need
         * to create one manually via {@link LambdaAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaAction.Builder#build()} is called immediately and its
         * result is passed to {@link #lambda(LambdaAction)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link LambdaAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(LambdaAction)
         */
        default Builder lambda(Consumer<LambdaAction.Builder> lambda) {
            return lambda(LambdaAction.builder().applyMutation(lambda).build());
        }

        /**
         * <p>
         * Sends AWS IoT Events input, which passes information about the detector model instance and the event that
         * triggered the action.
         * </p>
         * 
         * @param iotEvents
         *        Sends AWS IoT Events input, which passes information about the detector model instance and the event
         *        that triggered the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotEvents(IotEventsAction iotEvents);

        /**
         * <p>
         * Sends AWS IoT Events input, which passes information about the detector model instance and the event that
         * triggered the action.
         * </p>
         * This is a convenience method that creates an instance of the {@link IotEventsAction.Builder} avoiding the
         * need to create one manually via {@link IotEventsAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IotEventsAction.Builder#build()} is called immediately and its
         * result is passed to {@link #iotEvents(IotEventsAction)}.
         * 
         * @param iotEvents
         *        a consumer that will call methods on {@link IotEventsAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotEvents(IotEventsAction)
         */
        default Builder iotEvents(Consumer<IotEventsAction.Builder> iotEvents) {
            return iotEvents(IotEventsAction.builder().applyMutation(iotEvents).build());
        }

        /**
         * <p>
         * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS
         * queue.
         * </p>
         * 
         * @param sqs
         *        Sends information about the detector model instance and the event that triggered the action to an
         *        Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqs(SqsAction sqs);

        /**
         * <p>
         * Sends information about the detector model instance and the event that triggered the action to an Amazon SQS
         * queue.
         * </p>
         * This is a convenience method that creates an instance of the {@link SqsAction.Builder} avoiding the need to
         * create one manually via {@link SqsAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SqsAction.Builder#build()} is called immediately and its result
         * is passed to {@link #sqs(SqsAction)}.
         * 
         * @param sqs
         *        a consumer that will call methods on {@link SqsAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqs(SqsAction)
         */
        default Builder sqs(Consumer<SqsAction.Builder> sqs) {
            return sqs(SqsAction.builder().applyMutation(sqs).build());
        }

        /**
         * <p>
         * Sends information about the detector model instance and the event that triggered the action to an Amazon
         * Kinesis Data Firehose delivery stream.
         * </p>
         * 
         * @param firehose
         *        Sends information about the detector model instance and the event that triggered the action to an
         *        Amazon Kinesis Data Firehose delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehose(FirehoseAction firehose);

        /**
         * <p>
         * Sends information about the detector model instance and the event that triggered the action to an Amazon
         * Kinesis Data Firehose delivery stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link FirehoseAction.Builder} avoiding the need
         * to create one manually via {@link FirehoseAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FirehoseAction.Builder#build()} is called immediately and its
         * result is passed to {@link #firehose(FirehoseAction)}.
         * 
         * @param firehose
         *        a consumer that will call methods on {@link FirehoseAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firehose(FirehoseAction)
         */
        default Builder firehose(Consumer<FirehoseAction.Builder> firehose) {
            return firehose(FirehoseAction.builder().applyMutation(firehose).build());
        }

        /**
         * <p>
         * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs
         * that have the information about the detector model instance and the event that triggered the action. You can
         * customize the <a
         * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of
         * the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a>
         * in <i>AWS IoT Events Developer Guide</i>.
         * </p>
         * 
         * @param dynamoDB
         *        Writes to the DynamoDB table that you created. The default action payload contains all attribute-value
         *        pairs that have the information about the detector model instance and the event that triggered the
         *        action. You can customize the <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One
         *        column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html"
         *        >Actions</a> in <i>AWS IoT Events Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDB(DynamoDBAction dynamoDB);

        /**
         * <p>
         * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs
         * that have the information about the detector model instance and the event that triggered the action. You can
         * customize the <a
         * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of
         * the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information,
         * see <a
         * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a>
         * in <i>AWS IoT Events Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DynamoDBAction.Builder} avoiding the need
         * to create one manually via {@link DynamoDBAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynamoDBAction.Builder#build()} is called immediately and its
         * result is passed to {@link #dynamoDB(DynamoDBAction)}.
         * 
         * @param dynamoDB
         *        a consumer that will call methods on {@link DynamoDBAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDB(DynamoDBAction)
         */
        default Builder dynamoDB(Consumer<DynamoDBAction.Builder> dynamoDB) {
            return dynamoDB(DynamoDBAction.builder().applyMutation(dynamoDB).build());
        }

        /**
         * <p>
         * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs
         * that have the information about the detector model instance and the event that triggered the action. You can
         * customize the <a
         * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate
         * column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a>
         * in <i>AWS IoT Events Developer Guide</i>.
         * </p>
         * 
         * @param dynamoDBv2
         *        Writes to the DynamoDB table that you created. The default action payload contains all attribute-value
         *        pairs that have the information about the detector model instance and the event that triggered the
         *        action. You can customize the <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A
         *        separate column of the DynamoDB table receives one attribute-value pair in the payload that you
         *        specify. For more information, see <a
         *        href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html"
         *        >Actions</a> in <i>AWS IoT Events Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2);

        /**
         * <p>
         * Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs
         * that have the information about the detector model instance and the event that triggered the action. You can
         * customize the <a
         * href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate
         * column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a>
         * in <i>AWS IoT Events Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DynamoDBv2Action.Builder} avoiding the
         * need to create one manually via {@link DynamoDBv2Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DynamoDBv2Action.Builder#build()} is called immediately and its
         * result is passed to {@link #dynamoDBv2(DynamoDBv2Action)}.
         * 
         * @param dynamoDBv2
         *        a consumer that will call methods on {@link DynamoDBv2Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDBv2(DynamoDBv2Action)
         */
        default Builder dynamoDBv2(Consumer<DynamoDBv2Action.Builder> dynamoDBv2) {
            return dynamoDBv2(DynamoDBv2Action.builder().applyMutation(dynamoDBv2).build());
        }

        /**
         * <p>
         * Sends information about the detector model instance and the event that triggered the action to an asset
         * property in AWS IoT SiteWise .
         * </p>
         * 
         * @param iotSiteWise
         *        Sends information about the detector model instance and the event that triggered the action to an
         *        asset property in AWS IoT SiteWise .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotSiteWise(IotSiteWiseAction iotSiteWise);

        /**
         * <p>
         * Sends information about the detector model instance and the event that triggered the action to an asset
         * property in AWS IoT SiteWise .
         * </p>
         * This is a convenience method that creates an instance of the {@link IotSiteWiseAction.Builder} avoiding the
         * need to create one manually via {@link IotSiteWiseAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IotSiteWiseAction.Builder#build()} is called immediately and its
         * result is passed to {@link #iotSiteWise(IotSiteWiseAction)}.
         * 
         * @param iotSiteWise
         *        a consumer that will call methods on {@link IotSiteWiseAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotSiteWise(IotSiteWiseAction)
         */
        default Builder iotSiteWise(Consumer<IotSiteWiseAction.Builder> iotSiteWise) {
            return iotSiteWise(IotSiteWiseAction.builder().applyMutation(iotSiteWise).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SetVariableAction setVariable;

        private SNSTopicPublishAction sns;

        private IotTopicPublishAction iotTopicPublish;

        private SetTimerAction setTimer;

        private ClearTimerAction clearTimer;

        private ResetTimerAction resetTimer;

        private LambdaAction lambda;

        private IotEventsAction iotEvents;

        private SqsAction sqs;

        private FirehoseAction firehose;

        private DynamoDBAction dynamoDB;

        private DynamoDBv2Action dynamoDBv2;

        private IotSiteWiseAction iotSiteWise;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            setVariable(model.setVariable);
            sns(model.sns);
            iotTopicPublish(model.iotTopicPublish);
            setTimer(model.setTimer);
            clearTimer(model.clearTimer);
            resetTimer(model.resetTimer);
            lambda(model.lambda);
            iotEvents(model.iotEvents);
            sqs(model.sqs);
            firehose(model.firehose);
            dynamoDB(model.dynamoDB);
            dynamoDBv2(model.dynamoDBv2);
            iotSiteWise(model.iotSiteWise);
        }

        public final SetVariableAction.Builder getSetVariable() {
            return setVariable != null ? setVariable.toBuilder() : null;
        }

        public final void setSetVariable(SetVariableAction.BuilderImpl setVariable) {
            this.setVariable = setVariable != null ? setVariable.build() : null;
        }

        @Override
        @Transient
        public final Builder setVariable(SetVariableAction setVariable) {
            this.setVariable = setVariable;
            return this;
        }

        public final SNSTopicPublishAction.Builder getSns() {
            return sns != null ? sns.toBuilder() : null;
        }

        public final void setSns(SNSTopicPublishAction.BuilderImpl sns) {
            this.sns = sns != null ? sns.build() : null;
        }

        @Override
        public final Builder sns(SNSTopicPublishAction sns) {
            this.sns = sns;
            return this;
        }

        public final IotTopicPublishAction.Builder getIotTopicPublish() {
            return iotTopicPublish != null ? iotTopicPublish.toBuilder() : null;
        }

        public final void setIotTopicPublish(IotTopicPublishAction.BuilderImpl iotTopicPublish) {
            this.iotTopicPublish = iotTopicPublish != null ? iotTopicPublish.build() : null;
        }

        @Override
        public final Builder iotTopicPublish(IotTopicPublishAction iotTopicPublish) {
            this.iotTopicPublish = iotTopicPublish;
            return this;
        }

        public final SetTimerAction.Builder getSetTimer() {
            return setTimer != null ? setTimer.toBuilder() : null;
        }

        public final void setSetTimer(SetTimerAction.BuilderImpl setTimer) {
            this.setTimer = setTimer != null ? setTimer.build() : null;
        }

        @Override
        @Transient
        public final Builder setTimer(SetTimerAction setTimer) {
            this.setTimer = setTimer;
            return this;
        }

        public final ClearTimerAction.Builder getClearTimer() {
            return clearTimer != null ? clearTimer.toBuilder() : null;
        }

        public final void setClearTimer(ClearTimerAction.BuilderImpl clearTimer) {
            this.clearTimer = clearTimer != null ? clearTimer.build() : null;
        }

        @Override
        public final Builder clearTimer(ClearTimerAction clearTimer) {
            this.clearTimer = clearTimer;
            return this;
        }

        public final ResetTimerAction.Builder getResetTimer() {
            return resetTimer != null ? resetTimer.toBuilder() : null;
        }

        public final void setResetTimer(ResetTimerAction.BuilderImpl resetTimer) {
            this.resetTimer = resetTimer != null ? resetTimer.build() : null;
        }

        @Override
        public final Builder resetTimer(ResetTimerAction resetTimer) {
            this.resetTimer = resetTimer;
            return this;
        }

        public final LambdaAction.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaAction.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public final Builder lambda(LambdaAction lambda) {
            this.lambda = lambda;
            return this;
        }

        public final IotEventsAction.Builder getIotEvents() {
            return iotEvents != null ? iotEvents.toBuilder() : null;
        }

        public final void setIotEvents(IotEventsAction.BuilderImpl iotEvents) {
            this.iotEvents = iotEvents != null ? iotEvents.build() : null;
        }

        @Override
        public final Builder iotEvents(IotEventsAction iotEvents) {
            this.iotEvents = iotEvents;
            return this;
        }

        public final SqsAction.Builder getSqs() {
            return sqs != null ? sqs.toBuilder() : null;
        }

        public final void setSqs(SqsAction.BuilderImpl sqs) {
            this.sqs = sqs != null ? sqs.build() : null;
        }

        @Override
        public final Builder sqs(SqsAction sqs) {
            this.sqs = sqs;
            return this;
        }

        public final FirehoseAction.Builder getFirehose() {
            return firehose != null ? firehose.toBuilder() : null;
        }

        public final void setFirehose(FirehoseAction.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        @Override
        public final Builder firehose(FirehoseAction firehose) {
            this.firehose = firehose;
            return this;
        }

        public final DynamoDBAction.Builder getDynamoDB() {
            return dynamoDB != null ? dynamoDB.toBuilder() : null;
        }

        public final void setDynamoDB(DynamoDBAction.BuilderImpl dynamoDB) {
            this.dynamoDB = dynamoDB != null ? dynamoDB.build() : null;
        }

        @Override
        public final Builder dynamoDB(DynamoDBAction dynamoDB) {
            this.dynamoDB = dynamoDB;
            return this;
        }

        public final DynamoDBv2Action.Builder getDynamoDBv2() {
            return dynamoDBv2 != null ? dynamoDBv2.toBuilder() : null;
        }

        public final void setDynamoDBv2(DynamoDBv2Action.BuilderImpl dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2 != null ? dynamoDBv2.build() : null;
        }

        @Override
        public final Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2;
            return this;
        }

        public final IotSiteWiseAction.Builder getIotSiteWise() {
            return iotSiteWise != null ? iotSiteWise.toBuilder() : null;
        }

        public final void setIotSiteWise(IotSiteWiseAction.BuilderImpl iotSiteWise) {
            this.iotSiteWise = iotSiteWise != null ? iotSiteWise.build() : null;
        }

        @Override
        public final Builder iotSiteWise(IotSiteWiseAction iotSiteWise) {
            this.iotSiteWise = iotSiteWise;
            return this;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
