/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the Publish operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishRequest extends IotDataPlaneRequest implements
        ToCopyableBuilder<PublishRequest.Builder, PublishRequest> {
    private static final SdkField<String> TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("topic")
            .getter(getter(PublishRequest::topic)).setter(setter(Builder::topic))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("topic").build()).build();

    private static final SdkField<Integer> QOS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("qos")
            .getter(getter(PublishRequest::qos)).setter(setter(Builder::qos))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("qos").build()).build();

    private static final SdkField<Boolean> RETAIN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("retain").getter(getter(PublishRequest::retain)).setter(setter(Builder::retain))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("retain").build()).build();

    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("payload")
            .getter(getter(PublishRequest::payload))
            .setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> USER_PROPERTIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("userProperties")
            .getter(getter(PublishRequest::userProperties))
            .setter(setter(Builder::userProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-mqtt5-user-properties").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> PAYLOAD_FORMAT_INDICATOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("payloadFormatIndicator")
            .getter(getter(PublishRequest::payloadFormatIndicatorAsString))
            .setter(setter(Builder::payloadFormatIndicator))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER)
                    .locationName("x-amz-mqtt5-payload-format-indicator").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(PublishRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("contentType").build()).build();

    private static final SdkField<String> RESPONSE_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseTopic").getter(getter(PublishRequest::responseTopic)).setter(setter(Builder::responseTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("responseTopic").build()).build();

    private static final SdkField<String> CORRELATION_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("correlationData")
            .getter(getter(PublishRequest::correlationData))
            .setter(setter(Builder::correlationData))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-mqtt5-correlation-data")
                    .build()).build();

    private static final SdkField<Long> MESSAGE_EXPIRY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("messageExpiry").getter(getter(PublishRequest::messageExpiry)).setter(setter(Builder::messageExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("messageExpiry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_FIELD, QOS_FIELD,
            RETAIN_FIELD, PAYLOAD_FIELD, USER_PROPERTIES_FIELD, PAYLOAD_FORMAT_INDICATOR_FIELD, CONTENT_TYPE_FIELD,
            RESPONSE_TOPIC_FIELD, CORRELATION_DATA_FIELD, MESSAGE_EXPIRY_FIELD));

    private final String topic;

    private final Integer qos;

    private final Boolean retain;

    private final SdkBytes payload;

    private final String userProperties;

    private final String payloadFormatIndicator;

    private final String contentType;

    private final String responseTopic;

    private final String correlationData;

    private final Long messageExpiry;

    private PublishRequest(BuilderImpl builder) {
        super(builder);
        this.topic = builder.topic;
        this.qos = builder.qos;
        this.retain = builder.retain;
        this.payload = builder.payload;
        this.userProperties = builder.userProperties;
        this.payloadFormatIndicator = builder.payloadFormatIndicator;
        this.contentType = builder.contentType;
        this.responseTopic = builder.responseTopic;
        this.correlationData = builder.correlationData;
        this.messageExpiry = builder.messageExpiry;
    }

    /**
     * <p>
     * The name of the MQTT topic.
     * </p>
     * 
     * @return The name of the MQTT topic.
     */
    public final String topic() {
        return topic;
    }

    /**
     * <p>
     * The Quality of Service (QoS) level. The default QoS level is 0.
     * </p>
     * 
     * @return The Quality of Service (QoS) level. The default QoS level is 0.
     */
    public final Integer qos() {
        return qos;
    }

    /**
     * <p>
     * A Boolean value that determines whether to set the RETAIN flag when the message is published.
     * </p>
     * <p>
     * Setting the RETAIN flag causes the message to be retained and sent to new subscribers to the topic.
     * </p>
     * <p>
     * Valid values: <code>true</code> | <code>false</code>
     * </p>
     * <p>
     * Default value: <code>false</code>
     * </p>
     * 
     * @return A Boolean value that determines whether to set the RETAIN flag when the message is published.</p>
     *         <p>
     *         Setting the RETAIN flag causes the message to be retained and sent to new subscribers to the topic.
     *         </p>
     *         <p>
     *         Valid values: <code>true</code> | <code>false</code>
     *         </p>
     *         <p>
     *         Default value: <code>false</code>
     */
    public final Boolean retain() {
        return retain;
    }

    /**
     * <p>
     * The message body. MQTT accepts text, binary, and empty (null) message payloads.
     * </p>
     * <p>
     * Publishing an empty (null) payload with <b>retain</b> = <code>true</code> deletes the retained message identified
     * by <b>topic</b> from Amazon Web Services IoT Core.
     * </p>
     * 
     * @return The message body. MQTT accepts text, binary, and empty (null) message payloads.</p>
     *         <p>
     *         Publishing an empty (null) payload with <b>retain</b> = <code>true</code> deletes the retained message
     *         identified by <b>topic</b> from Amazon Web Services IoT Core.
     */
    public final SdkBytes payload() {
        return payload;
    }

    /**
     * <p>
     * A JSON string that contains an array of JSON objects. If you don’t use Amazon Web Services SDK or CLI, you must
     * encode the JSON string to base64 format before adding it to the HTTP header. <code>userProperties</code> is an
     * HTTP header value in the API.
     * </p>
     * <p>
     * The following example <code>userProperties</code> parameter is a JSON string which represents two User
     * Properties. Note that it needs to be base64-encoded:
     * </p>
     * <p>
     * <code>[{"deviceName": "alpha"}, {"deviceCnt": "45"}]</code>
     * </p>
     * 
     * @return A JSON string that contains an array of JSON objects. If you don’t use Amazon Web Services SDK or CLI,
     *         you must encode the JSON string to base64 format before adding it to the HTTP header.
     *         <code>userProperties</code> is an HTTP header value in the API.</p>
     *         <p>
     *         The following example <code>userProperties</code> parameter is a JSON string which represents two User
     *         Properties. Note that it needs to be base64-encoded:
     *         </p>
     *         <p>
     *         <code>[{"deviceName": "alpha"}, {"deviceCnt": "45"}]</code>
     */
    public final String userProperties() {
        return userProperties;
    }

    /**
     * <p>
     * An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
     * <code>payloadFormatIndicator</code> is an HTTP header value in the API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #payloadFormatIndicator} will return {@link PayloadFormatIndicator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #payloadFormatIndicatorAsString}.
     * </p>
     * 
     * @return An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
     *         <code>payloadFormatIndicator</code> is an HTTP header value in the API.
     * @see PayloadFormatIndicator
     */
    public final PayloadFormatIndicator payloadFormatIndicator() {
        return PayloadFormatIndicator.fromValue(payloadFormatIndicator);
    }

    /**
     * <p>
     * An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
     * <code>payloadFormatIndicator</code> is an HTTP header value in the API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #payloadFormatIndicator} will return {@link PayloadFormatIndicator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #payloadFormatIndicatorAsString}.
     * </p>
     * 
     * @return An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
     *         <code>payloadFormatIndicator</code> is an HTTP header value in the API.
     * @see PayloadFormatIndicator
     */
    public final String payloadFormatIndicatorAsString() {
        return payloadFormatIndicator;
    }

    /**
     * <p>
     * A UTF-8 encoded string that describes the content of the publishing message.
     * </p>
     * 
     * @return A UTF-8 encoded string that describes the content of the publishing message.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * A UTF-8 encoded string that's used as the topic name for a response message. The response topic is used to
     * describe the topic which the receiver should publish to as part of the request-response flow. The topic must not
     * contain wildcard characters.
     * </p>
     * 
     * @return A UTF-8 encoded string that's used as the topic name for a response message. The response topic is used
     *         to describe the topic which the receiver should publish to as part of the request-response flow. The
     *         topic must not contain wildcard characters.
     */
    public final String responseTopic() {
        return responseTopic;
    }

    /**
     * <p>
     * The base64-encoded binary data used by the sender of the request message to identify which request the response
     * message is for when it's received. <code>correlationData</code> is an HTTP header value in the API.
     * </p>
     * 
     * @return The base64-encoded binary data used by the sender of the request message to identify which request the
     *         response message is for when it's received. <code>correlationData</code> is an HTTP header value in the
     *         API.
     */
    public final String correlationData() {
        return correlationData;
    }

    /**
     * <p>
     * A user-defined integer value that represents the message expiry interval in seconds. If absent, the message
     * doesn't expire. For more information about the limits of <code>messageExpiry</code>, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/iot-core.html#message-broker-limits">Amazon Web Services IoT
     * Core message broker and protocol limits and quotas </a> from the Amazon Web Services Reference Guide.
     * </p>
     * 
     * @return A user-defined integer value that represents the message expiry interval in seconds. If absent, the
     *         message doesn't expire. For more information about the limits of <code>messageExpiry</code>, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/iot-core.html#message-broker-limits">Amazon Web
     *         Services IoT Core message broker and protocol limits and quotas </a> from the Amazon Web Services
     *         Reference Guide.
     */
    public final Long messageExpiry() {
        return messageExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        hashCode = 31 * hashCode + Objects.hashCode(qos());
        hashCode = 31 * hashCode + Objects.hashCode(retain());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(userProperties());
        hashCode = 31 * hashCode + Objects.hashCode(payloadFormatIndicatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(responseTopic());
        hashCode = 31 * hashCode + Objects.hashCode(correlationData());
        hashCode = 31 * hashCode + Objects.hashCode(messageExpiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest) obj;
        return Objects.equals(topic(), other.topic()) && Objects.equals(qos(), other.qos())
                && Objects.equals(retain(), other.retain()) && Objects.equals(payload(), other.payload())
                && Objects.equals(userProperties(), other.userProperties())
                && Objects.equals(payloadFormatIndicatorAsString(), other.payloadFormatIndicatorAsString())
                && Objects.equals(contentType(), other.contentType()) && Objects.equals(responseTopic(), other.responseTopic())
                && Objects.equals(correlationData(), other.correlationData())
                && Objects.equals(messageExpiry(), other.messageExpiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublishRequest").add("Topic", topic()).add("Qos", qos()).add("Retain", retain())
                .add("Payload", payload()).add("UserProperties", userProperties())
                .add("PayloadFormatIndicator", payloadFormatIndicatorAsString()).add("ContentType", contentType())
                .add("ResponseTopic", responseTopic()).add("CorrelationData", correlationData())
                .add("MessageExpiry", messageExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topic":
            return Optional.ofNullable(clazz.cast(topic()));
        case "qos":
            return Optional.ofNullable(clazz.cast(qos()));
        case "retain":
            return Optional.ofNullable(clazz.cast(retain()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "userProperties":
            return Optional.ofNullable(clazz.cast(userProperties()));
        case "payloadFormatIndicator":
            return Optional.ofNullable(clazz.cast(payloadFormatIndicatorAsString()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "responseTopic":
            return Optional.ofNullable(clazz.cast(responseTopic()));
        case "correlationData":
            return Optional.ofNullable(clazz.cast(correlationData()));
        case "messageExpiry":
            return Optional.ofNullable(clazz.cast(messageExpiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishRequest, T> g) {
        return obj -> g.apply((PublishRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDataPlaneRequest.Builder, SdkPojo, CopyableBuilder<Builder, PublishRequest> {
        /**
         * <p>
         * The name of the MQTT topic.
         * </p>
         * 
         * @param topic
         *        The name of the MQTT topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);

        /**
         * <p>
         * The Quality of Service (QoS) level. The default QoS level is 0.
         * </p>
         * 
         * @param qos
         *        The Quality of Service (QoS) level. The default QoS level is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qos(Integer qos);

        /**
         * <p>
         * A Boolean value that determines whether to set the RETAIN flag when the message is published.
         * </p>
         * <p>
         * Setting the RETAIN flag causes the message to be retained and sent to new subscribers to the topic.
         * </p>
         * <p>
         * Valid values: <code>true</code> | <code>false</code>
         * </p>
         * <p>
         * Default value: <code>false</code>
         * </p>
         * 
         * @param retain
         *        A Boolean value that determines whether to set the RETAIN flag when the message is published.</p>
         *        <p>
         *        Setting the RETAIN flag causes the message to be retained and sent to new subscribers to the topic.
         *        </p>
         *        <p>
         *        Valid values: <code>true</code> | <code>false</code>
         *        </p>
         *        <p>
         *        Default value: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retain(Boolean retain);

        /**
         * <p>
         * The message body. MQTT accepts text, binary, and empty (null) message payloads.
         * </p>
         * <p>
         * Publishing an empty (null) payload with <b>retain</b> = <code>true</code> deletes the retained message
         * identified by <b>topic</b> from Amazon Web Services IoT Core.
         * </p>
         * 
         * @param payload
         *        The message body. MQTT accepts text, binary, and empty (null) message payloads.</p>
         *        <p>
         *        Publishing an empty (null) payload with <b>retain</b> = <code>true</code> deletes the retained message
         *        identified by <b>topic</b> from Amazon Web Services IoT Core.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);

        /**
         * <p>
         * A JSON string that contains an array of JSON objects. If you don’t use Amazon Web Services SDK or CLI, you
         * must encode the JSON string to base64 format before adding it to the HTTP header. <code>userProperties</code>
         * is an HTTP header value in the API.
         * </p>
         * <p>
         * The following example <code>userProperties</code> parameter is a JSON string which represents two User
         * Properties. Note that it needs to be base64-encoded:
         * </p>
         * <p>
         * <code>[{"deviceName": "alpha"}, {"deviceCnt": "45"}]</code>
         * </p>
         * 
         * @param userProperties
         *        A JSON string that contains an array of JSON objects. If you don’t use Amazon Web Services SDK or CLI,
         *        you must encode the JSON string to base64 format before adding it to the HTTP header.
         *        <code>userProperties</code> is an HTTP header value in the API.</p>
         *        <p>
         *        The following example <code>userProperties</code> parameter is a JSON string which represents two User
         *        Properties. Note that it needs to be base64-encoded:
         *        </p>
         *        <p>
         *        <code>[{"deviceName": "alpha"}, {"deviceCnt": "45"}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProperties(String userProperties);

        /**
         * <p>
         * An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
         * <code>payloadFormatIndicator</code> is an HTTP header value in the API.
         * </p>
         * 
         * @param payloadFormatIndicator
         *        An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
         *        <code>payloadFormatIndicator</code> is an HTTP header value in the API.
         * @see PayloadFormatIndicator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadFormatIndicator
         */
        Builder payloadFormatIndicator(String payloadFormatIndicator);

        /**
         * <p>
         * An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
         * <code>payloadFormatIndicator</code> is an HTTP header value in the API.
         * </p>
         * 
         * @param payloadFormatIndicator
         *        An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
         *        <code>payloadFormatIndicator</code> is an HTTP header value in the API.
         * @see PayloadFormatIndicator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadFormatIndicator
         */
        Builder payloadFormatIndicator(PayloadFormatIndicator payloadFormatIndicator);

        /**
         * <p>
         * A UTF-8 encoded string that describes the content of the publishing message.
         * </p>
         * 
         * @param contentType
         *        A UTF-8 encoded string that describes the content of the publishing message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * A UTF-8 encoded string that's used as the topic name for a response message. The response topic is used to
         * describe the topic which the receiver should publish to as part of the request-response flow. The topic must
         * not contain wildcard characters.
         * </p>
         * 
         * @param responseTopic
         *        A UTF-8 encoded string that's used as the topic name for a response message. The response topic is
         *        used to describe the topic which the receiver should publish to as part of the request-response flow.
         *        The topic must not contain wildcard characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTopic(String responseTopic);

        /**
         * <p>
         * The base64-encoded binary data used by the sender of the request message to identify which request the
         * response message is for when it's received. <code>correlationData</code> is an HTTP header value in the API.
         * </p>
         * 
         * @param correlationData
         *        The base64-encoded binary data used by the sender of the request message to identify which request the
         *        response message is for when it's received. <code>correlationData</code> is an HTTP header value in
         *        the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder correlationData(String correlationData);

        /**
         * <p>
         * A user-defined integer value that represents the message expiry interval in seconds. If absent, the message
         * doesn't expire. For more information about the limits of <code>messageExpiry</code>, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/iot-core.html#message-broker-limits">Amazon Web Services
         * IoT Core message broker and protocol limits and quotas </a> from the Amazon Web Services Reference Guide.
         * </p>
         * 
         * @param messageExpiry
         *        A user-defined integer value that represents the message expiry interval in seconds. If absent, the
         *        message doesn't expire. For more information about the limits of <code>messageExpiry</code>, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/iot-core.html#message-broker-limits">Amazon Web
         *        Services IoT Core message broker and protocol limits and quotas </a> from the Amazon Web Services
         *        Reference Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageExpiry(Long messageExpiry);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotDataPlaneRequest.BuilderImpl implements Builder {
        private String topic;

        private Integer qos;

        private Boolean retain;

        private SdkBytes payload;

        private String userProperties;

        private String payloadFormatIndicator;

        private String contentType;

        private String responseTopic;

        private String correlationData;

        private Long messageExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishRequest model) {
            super(model);
            topic(model.topic);
            qos(model.qos);
            retain(model.retain);
            payload(model.payload);
            userProperties(model.userProperties);
            payloadFormatIndicator(model.payloadFormatIndicator);
            contentType(model.contentType);
            responseTopic(model.responseTopic);
            correlationData(model.correlationData);
            messageExpiry(model.messageExpiry);
        }

        public final String getTopic() {
            return topic;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final Integer getQos() {
            return qos;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        @Override
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final Boolean getRetain() {
            return retain;
        }

        public final void setRetain(Boolean retain) {
            this.retain = retain;
        }

        @Override
        public final Builder retain(Boolean retain) {
            this.retain = retain;
            return this;
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final String getUserProperties() {
            return userProperties;
        }

        public final void setUserProperties(String userProperties) {
            this.userProperties = userProperties;
        }

        @Override
        public final Builder userProperties(String userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        public final String getPayloadFormatIndicator() {
            return payloadFormatIndicator;
        }

        public final void setPayloadFormatIndicator(String payloadFormatIndicator) {
            this.payloadFormatIndicator = payloadFormatIndicator;
        }

        @Override
        public final Builder payloadFormatIndicator(String payloadFormatIndicator) {
            this.payloadFormatIndicator = payloadFormatIndicator;
            return this;
        }

        @Override
        public final Builder payloadFormatIndicator(PayloadFormatIndicator payloadFormatIndicator) {
            this.payloadFormatIndicator(payloadFormatIndicator == null ? null : payloadFormatIndicator.toString());
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getResponseTopic() {
            return responseTopic;
        }

        public final void setResponseTopic(String responseTopic) {
            this.responseTopic = responseTopic;
        }

        @Override
        public final Builder responseTopic(String responseTopic) {
            this.responseTopic = responseTopic;
            return this;
        }

        public final String getCorrelationData() {
            return correlationData;
        }

        public final void setCorrelationData(String correlationData) {
            this.correlationData = correlationData;
        }

        @Override
        public final Builder correlationData(String correlationData) {
            this.correlationData = correlationData;
            return this;
        }

        public final Long getMessageExpiry() {
            return messageExpiry;
        }

        public final void setMessageExpiry(Long messageExpiry) {
            this.messageExpiry = messageExpiry;
        }

        @Override
        public final Builder messageExpiry(Long messageExpiry) {
            this.messageExpiry = messageExpiry;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PublishRequest build() {
            return new PublishRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
