/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotanalytics.DefaultIoTAnalyticsBaseClientBuilder;
import software.amazon.awssdk.services.iotanalytics.DefaultIoTAnalyticsClient;
import software.amazon.awssdk.services.iotanalytics.IoTAnalyticsClient;
import software.amazon.awssdk.services.iotanalytics.IoTAnalyticsClientBuilder;
import software.amazon.awssdk.services.iotanalytics.IoTAnalyticsServiceClientConfiguration;
import software.amazon.awssdk.services.iotanalytics.endpoints.IoTAnalyticsEndpointProvider;

@SdkInternalApi
final class DefaultIoTAnalyticsClientBuilder
extends DefaultIoTAnalyticsBaseClientBuilder<IoTAnalyticsClientBuilder, IoTAnalyticsClient>
implements IoTAnalyticsClientBuilder {
    DefaultIoTAnalyticsClientBuilder() {
    }

    @Override
    public DefaultIoTAnalyticsClientBuilder endpointProvider(IoTAnalyticsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IoTAnalyticsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIoTAnalyticsClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        IoTAnalyticsServiceClientConfiguration serviceClientConfiguration = IoTAnalyticsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultIoTAnalyticsClient(serviceClientConfiguration, clientConfiguration);
    }
}

