/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse;

public class ListTargetsForPolicyIterable
implements SdkIterable<ListTargetsForPolicyResponse> {
    private final IotClient client;
    private final ListTargetsForPolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTargetsForPolicyIterable(IotClient client, ListTargetsForPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTargetsForPolicyResponseFetcher();
    }

    public Iterator<ListTargetsForPolicyResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> targets() {
        Function<ListTargetsForPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.targets() != null) {
                return response.targets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTargetsForPolicyResponseFetcher
    implements SyncPageFetcher<ListTargetsForPolicyResponse> {
        private ListTargetsForPolicyResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetsForPolicyResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListTargetsForPolicyResponse nextPage(ListTargetsForPolicyResponse previousPage) {
            if (previousPage == null) {
                return ListTargetsForPolicyIterable.this.client.listTargetsForPolicy(ListTargetsForPolicyIterable.this.firstRequest);
            }
            return ListTargetsForPolicyIterable.this.client.listTargetsForPolicy((ListTargetsForPolicyRequest)((Object)ListTargetsForPolicyIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

