/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.JobExecutionSummaryForThing;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse;

public class ListJobExecutionsForThingPublisher
implements SdkPublisher<ListJobExecutionsForThingResponse> {
    private final IotAsyncClient client;
    private final ListJobExecutionsForThingRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobExecutionsForThingPublisher(IotAsyncClient client, ListJobExecutionsForThingRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobExecutionsForThingPublisher(IotAsyncClient client, ListJobExecutionsForThingRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobExecutionsForThingResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobExecutionsForThingResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobExecutionSummaryForThing> executionSummaries() {
        Function<ListJobExecutionsForThingResponse, Iterator> getIterator = response -> {
            if (response != null && response.executionSummaries() != null) {
                return response.executionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobExecutionsForThingResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobExecutionsForThingResponseFetcher
    implements AsyncPageFetcher<ListJobExecutionsForThingResponse> {
        private ListJobExecutionsForThingResponseFetcher() {
        }

        public boolean hasNextPage(ListJobExecutionsForThingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJobExecutionsForThingResponse> nextPage(ListJobExecutionsForThingResponse previousPage) {
            if (previousPage == null) {
                return ListJobExecutionsForThingPublisher.this.client.listJobExecutionsForThing(ListJobExecutionsForThingPublisher.this.firstRequest);
            }
            return ListJobExecutionsForThingPublisher.this.client.listJobExecutionsForThing((ListJobExecutionsForThingRequest)((Object)ListJobExecutionsForThingPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

