/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.DetectMitigationActionExecution;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse;

public class ListDetectMitigationActionsExecutionsPublisher
implements SdkPublisher<ListDetectMitigationActionsExecutionsResponse> {
    private final IotAsyncClient client;
    private final ListDetectMitigationActionsExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDetectMitigationActionsExecutionsPublisher(IotAsyncClient client, ListDetectMitigationActionsExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDetectMitigationActionsExecutionsPublisher(IotAsyncClient client, ListDetectMitigationActionsExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDetectMitigationActionsExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDetectMitigationActionsExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DetectMitigationActionExecution> actionsExecutions() {
        Function<ListDetectMitigationActionsExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionsExecutions() != null) {
                return response.actionsExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDetectMitigationActionsExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDetectMitigationActionsExecutionsResponseFetcher
    implements AsyncPageFetcher<ListDetectMitigationActionsExecutionsResponse> {
        private ListDetectMitigationActionsExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDetectMitigationActionsExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDetectMitigationActionsExecutionsResponse> nextPage(ListDetectMitigationActionsExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListDetectMitigationActionsExecutionsPublisher.this.client.listDetectMitigationActionsExecutions(ListDetectMitigationActionsExecutionsPublisher.this.firstRequest);
            }
            return ListDetectMitigationActionsExecutionsPublisher.this.client.listDetectMitigationActionsExecutions((ListDetectMitigationActionsExecutionsRequest)((Object)ListDetectMitigationActionsExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

