/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.AuditSuppression;
import software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse;

public class ListAuditSuppressionsIterable
implements SdkIterable<ListAuditSuppressionsResponse> {
    private final IotClient client;
    private final ListAuditSuppressionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAuditSuppressionsIterable(IotClient client, ListAuditSuppressionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAuditSuppressionsResponseFetcher();
    }

    public Iterator<ListAuditSuppressionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AuditSuppression> suppressions() {
        Function<ListAuditSuppressionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.suppressions() != null) {
                return response.suppressions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAuditSuppressionsResponseFetcher
    implements SyncPageFetcher<ListAuditSuppressionsResponse> {
        private ListAuditSuppressionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAuditSuppressionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAuditSuppressionsResponse nextPage(ListAuditSuppressionsResponse previousPage) {
            if (previousPage == null) {
                return ListAuditSuppressionsIterable.this.client.listAuditSuppressions(ListAuditSuppressionsIterable.this.firstRequest);
            }
            return ListAuditSuppressionsIterable.this.client.listAuditSuppressions((ListAuditSuppressionsRequest)((Object)ListAuditSuppressionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

