/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransferData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransferData> {
    private static final SdkField<String> TRANSFER_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transferMessage").getter(TransferData.getter(TransferData::transferMessage)).setter(TransferData.setter(Builder::transferMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferMessage").build()}).build();
    private static final SdkField<String> REJECT_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rejectReason").getter(TransferData.getter(TransferData::rejectReason)).setter(TransferData.setter(Builder::rejectReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectReason").build()}).build();
    private static final SdkField<Instant> TRANSFER_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("transferDate").getter(TransferData.getter(TransferData::transferDate)).setter(TransferData.setter(Builder::transferDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferDate").build()}).build();
    private static final SdkField<Instant> ACCEPT_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("acceptDate").getter(TransferData.getter(TransferData::acceptDate)).setter(TransferData.setter(Builder::acceptDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptDate").build()}).build();
    private static final SdkField<Instant> REJECT_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("rejectDate").getter(TransferData.getter(TransferData::rejectDate)).setter(TransferData.setter(Builder::rejectDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFER_MESSAGE_FIELD, REJECT_REASON_FIELD, TRANSFER_DATE_FIELD, ACCEPT_DATE_FIELD, REJECT_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transferMessage;
    private final String rejectReason;
    private final Instant transferDate;
    private final Instant acceptDate;
    private final Instant rejectDate;

    private TransferData(BuilderImpl builder) {
        this.transferMessage = builder.transferMessage;
        this.rejectReason = builder.rejectReason;
        this.transferDate = builder.transferDate;
        this.acceptDate = builder.acceptDate;
        this.rejectDate = builder.rejectDate;
    }

    public final String transferMessage() {
        return this.transferMessage;
    }

    public final String rejectReason() {
        return this.rejectReason;
    }

    public final Instant transferDate() {
        return this.transferDate;
    }

    public final Instant acceptDate() {
        return this.acceptDate;
    }

    public final Instant rejectDate() {
        return this.rejectDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transferMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferData)) {
            return false;
        }
        TransferData other = (TransferData)obj;
        return Objects.equals(this.transferMessage(), other.transferMessage()) && Objects.equals(this.rejectReason(), other.rejectReason()) && Objects.equals(this.transferDate(), other.transferDate()) && Objects.equals(this.acceptDate(), other.acceptDate()) && Objects.equals(this.rejectDate(), other.rejectDate());
    }

    public final String toString() {
        return ToString.builder((String)"TransferData").add("TransferMessage", (Object)this.transferMessage()).add("RejectReason", (Object)this.rejectReason()).add("TransferDate", (Object)this.transferDate()).add("AcceptDate", (Object)this.acceptDate()).add("RejectDate", (Object)this.rejectDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transferMessage": {
                return Optional.ofNullable(clazz.cast(this.transferMessage()));
            }
            case "rejectReason": {
                return Optional.ofNullable(clazz.cast(this.rejectReason()));
            }
            case "transferDate": {
                return Optional.ofNullable(clazz.cast(this.transferDate()));
            }
            case "acceptDate": {
                return Optional.ofNullable(clazz.cast(this.acceptDate()));
            }
            case "rejectDate": {
                return Optional.ofNullable(clazz.cast(this.rejectDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransferData, T> g) {
        return obj -> g.apply((TransferData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transferMessage;
        private String rejectReason;
        private Instant transferDate;
        private Instant acceptDate;
        private Instant rejectDate;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferData model) {
            this.transferMessage(model.transferMessage);
            this.rejectReason(model.rejectReason);
            this.transferDate(model.transferDate);
            this.acceptDate(model.acceptDate);
            this.rejectDate(model.rejectDate);
        }

        public final String getTransferMessage() {
            return this.transferMessage;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        public final String getRejectReason() {
            return this.rejectReason;
        }

        public final void setRejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
        }

        @Override
        public final Builder rejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
            return this;
        }

        public final Instant getTransferDate() {
            return this.transferDate;
        }

        public final void setTransferDate(Instant transferDate) {
            this.transferDate = transferDate;
        }

        @Override
        public final Builder transferDate(Instant transferDate) {
            this.transferDate = transferDate;
            return this;
        }

        public final Instant getAcceptDate() {
            return this.acceptDate;
        }

        public final void setAcceptDate(Instant acceptDate) {
            this.acceptDate = acceptDate;
        }

        @Override
        public final Builder acceptDate(Instant acceptDate) {
            this.acceptDate = acceptDate;
            return this;
        }

        public final Instant getRejectDate() {
            return this.rejectDate;
        }

        public final void setRejectDate(Instant rejectDate) {
            this.rejectDate = rejectDate;
        }

        @Override
        public final Builder rejectDate(Instant rejectDate) {
            this.rejectDate = rejectDate;
            return this;
        }

        public TransferData build() {
            return new TransferData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransferData> {
        public Builder transferMessage(String var1);

        public Builder rejectReason(String var1);

        public Builder transferDate(Instant var1);

        public Builder acceptDate(Instant var1);

        public Builder rejectDate(Instant var1);
    }
}

