/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.Tag;
import software.amazon.awssdk.services.iot.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRoleAliasRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateRoleAliasRequest> {
    private static final SdkField<String> ROLE_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleAlias").getter(CreateRoleAliasRequest.getter(CreateRoleAliasRequest::roleAlias)).setter(CreateRoleAliasRequest.setter(Builder::roleAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("roleAlias").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateRoleAliasRequest.getter(CreateRoleAliasRequest::roleArn)).setter(CreateRoleAliasRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Integer> CREDENTIAL_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("credentialDurationSeconds").getter(CreateRoleAliasRequest.getter(CreateRoleAliasRequest::credentialDurationSeconds)).setter(CreateRoleAliasRequest.setter(Builder::credentialDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialDurationSeconds").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateRoleAliasRequest.getter(CreateRoleAliasRequest::tags)).setter(CreateRoleAliasRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ALIAS_FIELD, ROLE_ARN_FIELD, CREDENTIAL_DURATION_SECONDS_FIELD, TAGS_FIELD));
    private final String roleAlias;
    private final String roleArn;
    private final Integer credentialDurationSeconds;
    private final List<Tag> tags;

    private CreateRoleAliasRequest(BuilderImpl builder) {
        super(builder);
        this.roleAlias = builder.roleAlias;
        this.roleArn = builder.roleArn;
        this.credentialDurationSeconds = builder.credentialDurationSeconds;
        this.tags = builder.tags;
    }

    public final String roleAlias() {
        return this.roleAlias;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Integer credentialDurationSeconds() {
        return this.credentialDurationSeconds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoleAliasRequest)) {
            return false;
        }
        CreateRoleAliasRequest other = (CreateRoleAliasRequest)((Object)obj);
        return Objects.equals(this.roleAlias(), other.roleAlias()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.credentialDurationSeconds(), other.credentialDurationSeconds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRoleAliasRequest").add("RoleAlias", (Object)this.roleAlias()).add("RoleArn", (Object)this.roleArn()).add("CredentialDurationSeconds", (Object)this.credentialDurationSeconds()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleAlias": {
                return Optional.ofNullable(clazz.cast(this.roleAlias()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "credentialDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.credentialDurationSeconds()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoleAliasRequest, T> g) {
        return obj -> g.apply((CreateRoleAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String roleAlias;
        private String roleArn;
        private Integer credentialDurationSeconds;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoleAliasRequest model) {
            super(model);
            this.roleAlias(model.roleAlias);
            this.roleArn(model.roleArn);
            this.credentialDurationSeconds(model.credentialDurationSeconds);
            this.tags(model.tags);
        }

        public final String getRoleAlias() {
            return this.roleAlias;
        }

        public final void setRoleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
        }

        @Override
        public final Builder roleAlias(String roleAlias) {
            this.roleAlias = roleAlias;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Integer getCredentialDurationSeconds() {
            return this.credentialDurationSeconds;
        }

        public final void setCredentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
        }

        @Override
        public final Builder credentialDurationSeconds(Integer credentialDurationSeconds) {
            this.credentialDurationSeconds = credentialDurationSeconds;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRoleAliasRequest build() {
            return new CreateRoleAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRoleAliasRequest> {
        public Builder roleAlias(String var1);

        public Builder roleArn(String var1);

        public Builder credentialDurationSeconds(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

