/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterCertificateWithoutCaRequest extends IotRequest implements
        ToCopyableBuilder<RegisterCertificateWithoutCaRequest.Builder, RegisterCertificateWithoutCaRequest> {
    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificatePem").getter(getter(RegisterCertificateWithoutCaRequest::certificatePem))
            .setter(setter(Builder::certificatePem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RegisterCertificateWithoutCaRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_PEM_FIELD,
            STATUS_FIELD));

    private final String certificatePem;

    private final String status;

    private RegisterCertificateWithoutCaRequest(BuilderImpl builder) {
        super(builder);
        this.certificatePem = builder.certificatePem;
        this.status = builder.status;
    }

    /**
     * <p>
     * The certificate data, in PEM format.
     * </p>
     * 
     * @return The certificate data, in PEM format.
     */
    public final String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The status of the register certificate request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the register certificate request.
     * @see CertificateStatus
     */
    public final CertificateStatus status() {
        return CertificateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the register certificate request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the register certificate request.
     * @see CertificateStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterCertificateWithoutCaRequest)) {
            return false;
        }
        RegisterCertificateWithoutCaRequest other = (RegisterCertificateWithoutCaRequest) obj;
        return Objects.equals(certificatePem(), other.certificatePem())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterCertificateWithoutCaRequest").add("CertificatePem", certificatePem())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificatePem":
            return Optional.ofNullable(clazz.cast(certificatePem()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterCertificateWithoutCaRequest, T> g) {
        return obj -> g.apply((RegisterCertificateWithoutCaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterCertificateWithoutCaRequest> {
        /**
         * <p>
         * The certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The status of the register certificate request.
         * </p>
         * 
         * @param status
         *        The status of the register certificate request.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the register certificate request.
         * </p>
         * 
         * @param status
         *        The status of the register certificate request.
         * @see CertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateStatus
         */
        Builder status(CertificateStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String certificatePem;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterCertificateWithoutCaRequest model) {
            super(model);
            certificatePem(model.certificatePem);
            status(model.status);
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterCertificateWithoutCaRequest build() {
            return new RegisterCertificateWithoutCaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
