/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The certificate issuer indentifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IssuerCertificateIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<IssuerCertificateIdentifier.Builder, IssuerCertificateIdentifier> {
    private static final SdkField<String> ISSUER_CERTIFICATE_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("issuerCertificateSubject").getter(getter(IssuerCertificateIdentifier::issuerCertificateSubject))
            .setter(setter(Builder::issuerCertificateSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerCertificateSubject").build())
            .build();

    private static final SdkField<String> ISSUER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("issuerId").getter(getter(IssuerCertificateIdentifier::issuerId)).setter(setter(Builder::issuerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerId").build()).build();

    private static final SdkField<String> ISSUER_CERTIFICATE_SERIAL_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("issuerCertificateSerialNumber")
            .getter(getter(IssuerCertificateIdentifier::issuerCertificateSerialNumber))
            .setter(setter(Builder::issuerCertificateSerialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerCertificateSerialNumber")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ISSUER_CERTIFICATE_SUBJECT_FIELD, ISSUER_ID_FIELD, ISSUER_CERTIFICATE_SERIAL_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String issuerCertificateSubject;

    private final String issuerId;

    private final String issuerCertificateSerialNumber;

    private IssuerCertificateIdentifier(BuilderImpl builder) {
        this.issuerCertificateSubject = builder.issuerCertificateSubject;
        this.issuerId = builder.issuerId;
        this.issuerCertificateSerialNumber = builder.issuerCertificateSerialNumber;
    }

    /**
     * <p>
     * The subject of the issuer certificate.
     * </p>
     * 
     * @return The subject of the issuer certificate.
     */
    public final String issuerCertificateSubject() {
        return issuerCertificateSubject;
    }

    /**
     * <p>
     * The issuer ID.
     * </p>
     * 
     * @return The issuer ID.
     */
    public final String issuerId() {
        return issuerId;
    }

    /**
     * <p>
     * The issuer certificate serial number.
     * </p>
     * 
     * @return The issuer certificate serial number.
     */
    public final String issuerCertificateSerialNumber() {
        return issuerCertificateSerialNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(issuerCertificateSubject());
        hashCode = 31 * hashCode + Objects.hashCode(issuerId());
        hashCode = 31 * hashCode + Objects.hashCode(issuerCertificateSerialNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IssuerCertificateIdentifier)) {
            return false;
        }
        IssuerCertificateIdentifier other = (IssuerCertificateIdentifier) obj;
        return Objects.equals(issuerCertificateSubject(), other.issuerCertificateSubject())
                && Objects.equals(issuerId(), other.issuerId())
                && Objects.equals(issuerCertificateSerialNumber(), other.issuerCertificateSerialNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IssuerCertificateIdentifier").add("IssuerCertificateSubject", issuerCertificateSubject())
                .add("IssuerId", issuerId()).add("IssuerCertificateSerialNumber", issuerCertificateSerialNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "issuerCertificateSubject":
            return Optional.ofNullable(clazz.cast(issuerCertificateSubject()));
        case "issuerId":
            return Optional.ofNullable(clazz.cast(issuerId()));
        case "issuerCertificateSerialNumber":
            return Optional.ofNullable(clazz.cast(issuerCertificateSerialNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IssuerCertificateIdentifier, T> g) {
        return obj -> g.apply((IssuerCertificateIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IssuerCertificateIdentifier> {
        /**
         * <p>
         * The subject of the issuer certificate.
         * </p>
         * 
         * @param issuerCertificateSubject
         *        The subject of the issuer certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuerCertificateSubject(String issuerCertificateSubject);

        /**
         * <p>
         * The issuer ID.
         * </p>
         * 
         * @param issuerId
         *        The issuer ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuerId(String issuerId);

        /**
         * <p>
         * The issuer certificate serial number.
         * </p>
         * 
         * @param issuerCertificateSerialNumber
         *        The issuer certificate serial number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuerCertificateSerialNumber(String issuerCertificateSerialNumber);
    }

    static final class BuilderImpl implements Builder {
        private String issuerCertificateSubject;

        private String issuerId;

        private String issuerCertificateSerialNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(IssuerCertificateIdentifier model) {
            issuerCertificateSubject(model.issuerCertificateSubject);
            issuerId(model.issuerId);
            issuerCertificateSerialNumber(model.issuerCertificateSerialNumber);
        }

        public final String getIssuerCertificateSubject() {
            return issuerCertificateSubject;
        }

        public final void setIssuerCertificateSubject(String issuerCertificateSubject) {
            this.issuerCertificateSubject = issuerCertificateSubject;
        }

        @Override
        public final Builder issuerCertificateSubject(String issuerCertificateSubject) {
            this.issuerCertificateSubject = issuerCertificateSubject;
            return this;
        }

        public final String getIssuerId() {
            return issuerId;
        }

        public final void setIssuerId(String issuerId) {
            this.issuerId = issuerId;
        }

        @Override
        public final Builder issuerId(String issuerId) {
            this.issuerId = issuerId;
            return this;
        }

        public final String getIssuerCertificateSerialNumber() {
            return issuerCertificateSerialNumber;
        }

        public final void setIssuerCertificateSerialNumber(String issuerCertificateSerialNumber) {
            this.issuerCertificateSerialNumber = issuerCertificateSerialNumber;
        }

        @Override
        public final Builder issuerCertificateSerialNumber(String issuerCertificateSerialNumber) {
            this.issuerCertificateSerialNumber = issuerCertificateSerialNumber;
            return this;
        }

        @Override
        public IssuerCertificateIdentifier build() {
            return new IssuerCertificateIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
