/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesFilterCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchVulnerabilitiesRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, SearchVulnerabilitiesRequest> {
    private static final SdkField<SearchVulnerabilitiesFilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterCriteria").getter(SearchVulnerabilitiesRequest.getter(SearchVulnerabilitiesRequest::filterCriteria)).setter(SearchVulnerabilitiesRequest.setter(Builder::filterCriteria)).constructor(SearchVulnerabilitiesFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchVulnerabilitiesRequest.getter(SearchVulnerabilitiesRequest::nextToken)).setter(SearchVulnerabilitiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERIA_FIELD, NEXT_TOKEN_FIELD));
    private final SearchVulnerabilitiesFilterCriteria filterCriteria;
    private final String nextToken;

    private SearchVulnerabilitiesRequest(BuilderImpl builder) {
        super(builder);
        this.filterCriteria = builder.filterCriteria;
        this.nextToken = builder.nextToken;
    }

    public final SearchVulnerabilitiesFilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchVulnerabilitiesRequest)) {
            return false;
        }
        SearchVulnerabilitiesRequest other = (SearchVulnerabilitiesRequest)((Object)obj);
        return Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchVulnerabilitiesRequest").add("FilterCriteria", (Object)this.filterCriteria()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchVulnerabilitiesRequest, T> g) {
        return obj -> g.apply((SearchVulnerabilitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private SearchVulnerabilitiesFilterCriteria filterCriteria;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchVulnerabilitiesRequest model) {
            super(model);
            this.filterCriteria(model.filterCriteria);
            this.nextToken(model.nextToken);
        }

        public final SearchVulnerabilitiesFilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(SearchVulnerabilitiesFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(SearchVulnerabilitiesFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchVulnerabilitiesRequest build() {
            return new SearchVulnerabilitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchVulnerabilitiesRequest> {
        public Builder filterCriteria(SearchVulnerabilitiesFilterCriteria var1);

        default public Builder filterCriteria(Consumer<SearchVulnerabilitiesFilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((SearchVulnerabilitiesFilterCriteria)((SearchVulnerabilitiesFilterCriteria.Builder)SearchVulnerabilitiesFilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

