/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PackageType {
    IMAGE("IMAGE"),
    ZIP("ZIP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PackageType> VALUE_MAP;
    private final String value;

    private PackageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageType> knownValues() {
        EnumSet<PackageType> knownValues = EnumSet.allOf(PackageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PackageType.class, PackageType::toString);
    }
}

