/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.internal.UserAgentUtils;
import software.amazon.awssdk.services.inspector.model.ListExclusionsRequest;
import software.amazon.awssdk.services.inspector.model.ListExclusionsResponse;

public class ListExclusionsIterable
implements SdkIterable<ListExclusionsResponse> {
    private final InspectorClient client;
    private final ListExclusionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExclusionsIterable(InspectorClient client, ListExclusionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExclusionsResponseFetcher();
    }

    public Iterator<ListExclusionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListExclusionsResponseFetcher
    implements SyncPageFetcher<ListExclusionsResponse> {
        private ListExclusionsResponseFetcher() {
        }

        public boolean hasNextPage(ListExclusionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExclusionsResponse nextPage(ListExclusionsResponse previousPage) {
            if (previousPage == null) {
                return ListExclusionsIterable.this.client.listExclusions(ListExclusionsIterable.this.firstRequest);
            }
            return ListExclusionsIterable.this.client.listExclusions((ListExclusionsRequest)((Object)ListExclusionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

