/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.inspector.DefaultInspectorAsyncClient;
import software.amazon.awssdk.services.inspector.DefaultInspectorBaseClientBuilder;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.InspectorAsyncClientBuilder;
import software.amazon.awssdk.services.inspector.InspectorServiceClientConfiguration;
import software.amazon.awssdk.services.inspector.endpoints.InspectorEndpointProvider;

@SdkInternalApi
final class DefaultInspectorAsyncClientBuilder
extends DefaultInspectorBaseClientBuilder<InspectorAsyncClientBuilder, InspectorAsyncClient>
implements InspectorAsyncClientBuilder {
    DefaultInspectorAsyncClientBuilder() {
    }

    @Override
    public DefaultInspectorAsyncClientBuilder endpointProvider(InspectorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final InspectorAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultInspectorAsyncClientBuilder.validateClientOptions(clientConfiguration);
        InspectorServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultInspectorAsyncClient client = new DefaultInspectorAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private InspectorServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return InspectorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

