/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.inspector.DefaultInspectorBaseClientBuilder;
import software.amazon.awssdk.services.inspector.DefaultInspectorClient;
import software.amazon.awssdk.services.inspector.InspectorClient;
import software.amazon.awssdk.services.inspector.InspectorClientBuilder;
import software.amazon.awssdk.services.inspector.InspectorServiceClientConfiguration;
import software.amazon.awssdk.services.inspector.endpoints.InspectorEndpointProvider;

@SdkInternalApi
final class DefaultInspectorClientBuilder
extends DefaultInspectorBaseClientBuilder<InspectorClientBuilder, InspectorClient>
implements InspectorClientBuilder {
    DefaultInspectorClientBuilder() {
    }

    @Override
    public DefaultInspectorClientBuilder endpointProvider(InspectorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final InspectorClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultInspectorClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        InspectorServiceClientConfiguration serviceClientConfiguration = InspectorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultInspectorClient(serviceClientConfiguration, clientConfiguration);
    }
}

