/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse;

public class ListAssessmentRunAgentsPublisher
implements SdkPublisher<ListAssessmentRunAgentsResponse> {
    private final InspectorAsyncClient client;
    private final ListAssessmentRunAgentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssessmentRunAgentsPublisher(InspectorAsyncClient client, ListAssessmentRunAgentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssessmentRunAgentsPublisher(InspectorAsyncClient client, ListAssessmentRunAgentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssessmentRunAgentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssessmentRunAgentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAssessmentRunAgentsResponseFetcher
    implements AsyncPageFetcher<ListAssessmentRunAgentsResponse> {
        private ListAssessmentRunAgentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentRunAgentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssessmentRunAgentsResponse> nextPage(ListAssessmentRunAgentsResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentRunAgentsPublisher.this.client.listAssessmentRunAgents(ListAssessmentRunAgentsPublisher.this.firstRequest);
            }
            return ListAssessmentRunAgentsPublisher.this.client.listAssessmentRunAgents((ListAssessmentRunAgentsRequest)((Object)ListAssessmentRunAgentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

