/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.inspector.model.AssessmentRun;
import software.amazon.awssdk.services.inspector.model.AssessmentRunListCopier;
import software.amazon.awssdk.services.inspector.model.FailedItemDetails;
import software.amazon.awssdk.services.inspector.model.FailedItemsCopier;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssessmentRunsResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, DescribeAssessmentRunsResponse> {
    private static final SdkField<List<AssessmentRun>> ASSESSMENT_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentRuns").getter(DescribeAssessmentRunsResponse.getter(DescribeAssessmentRunsResponse::assessmentRuns)).setter(DescribeAssessmentRunsResponse.setter(Builder::assessmentRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("failedItems").getter(DescribeAssessmentRunsResponse.getter(DescribeAssessmentRunsResponse::failedItems)).setter(DescribeAssessmentRunsResponse.setter(Builder::failedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedItemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUNS_FIELD, FAILED_ITEMS_FIELD));
    private final List<AssessmentRun> assessmentRuns;
    private final Map<String, FailedItemDetails> failedItems;

    private DescribeAssessmentRunsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentRuns = builder.assessmentRuns;
        this.failedItems = builder.failedItems;
    }

    public final boolean hasAssessmentRuns() {
        return this.assessmentRuns != null && !(this.assessmentRuns instanceof SdkAutoConstructList);
    }

    public final List<AssessmentRun> assessmentRuns() {
        return this.assessmentRuns;
    }

    public final boolean hasFailedItems() {
        return this.failedItems != null && !(this.failedItems instanceof SdkAutoConstructMap);
    }

    public final Map<String, FailedItemDetails> failedItems() {
        return this.failedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentRuns() ? this.assessmentRuns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedItems() ? this.failedItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentRunsResponse)) {
            return false;
        }
        DescribeAssessmentRunsResponse other = (DescribeAssessmentRunsResponse)((Object)obj);
        return this.hasAssessmentRuns() == other.hasAssessmentRuns() && Objects.equals(this.assessmentRuns(), other.assessmentRuns()) && this.hasFailedItems() == other.hasFailedItems() && Objects.equals(this.failedItems(), other.failedItems());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssessmentRunsResponse").add("AssessmentRuns", this.hasAssessmentRuns() ? this.assessmentRuns() : null).add("FailedItems", this.hasFailedItems() ? this.failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentRuns": {
                return Optional.ofNullable(clazz.cast(this.assessmentRuns()));
            }
            case "failedItems": {
                return Optional.ofNullable(clazz.cast(this.failedItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssessmentRunsResponse, T> g) {
        return obj -> g.apply((DescribeAssessmentRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<AssessmentRun> assessmentRuns = DefaultSdkAutoConstructList.getInstance();
        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssessmentRunsResponse model) {
            super(model);
            this.assessmentRuns(model.assessmentRuns);
            this.failedItems(model.failedItems);
        }

        public final Collection<AssessmentRun.Builder> getAssessmentRuns() {
            if (this.assessmentRuns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assessmentRuns != null ? (Collection)this.assessmentRuns.stream().map(AssessmentRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assessmentRuns(Collection<AssessmentRun> assessmentRuns) {
            this.assessmentRuns = AssessmentRunListCopier.copy(assessmentRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRuns(AssessmentRun ... assessmentRuns) {
            this.assessmentRuns(Arrays.asList(assessmentRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRuns(Consumer<AssessmentRun.Builder> ... assessmentRuns) {
            this.assessmentRuns(Stream.of(assessmentRuns).map(c -> (AssessmentRun)((AssessmentRun.Builder)AssessmentRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssessmentRuns(Collection<AssessmentRun.BuilderImpl> assessmentRuns) {
            this.assessmentRuns = AssessmentRunListCopier.copyFromBuilder(assessmentRuns);
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            if (this.failedItems instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.failedItems != null ? CollectionUtils.mapValues(this.failedItems, FailedItemDetails::toBuilder) : null;
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public DescribeAssessmentRunsResponse build() {
            return new DescribeAssessmentRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssessmentRunsResponse> {
        public Builder assessmentRuns(Collection<AssessmentRun> var1);

        public Builder assessmentRuns(AssessmentRun ... var1);

        public Builder assessmentRuns(Consumer<AssessmentRun.Builder> ... var1);

        public Builder failedItems(Map<String, FailedItemDetails> var1);
    }
}

