/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ImagePackage;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse;

public class ListImagePackagesPublisher
implements SdkPublisher<ListImagePackagesResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListImagePackagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImagePackagesPublisher(ImagebuilderAsyncClient client, ListImagePackagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImagePackagesPublisher(ImagebuilderAsyncClient client, ListImagePackagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImagePackagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImagePackagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImagePackage> imagePackageList() {
        Function<ListImagePackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imagePackageList() != null) {
                return response.imagePackageList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImagePackagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImagePackagesResponseFetcher
    implements AsyncPageFetcher<ListImagePackagesResponse> {
        private ListImagePackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagePackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImagePackagesResponse> nextPage(ListImagePackagesResponse previousPage) {
            if (previousPage == null) {
                return ListImagePackagesPublisher.this.client.listImagePackages(ListImagePackagesPublisher.this.firstRequest);
            }
            return ListImagePackagesPublisher.this.client.listImagePackages((ListImagePackagesRequest)((Object)ListImagePackagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

