/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingAggregation;
import software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingAggregationsListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImageScanFindingAggregationsResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListImageScanFindingAggregationsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(ListImageScanFindingAggregationsResponse.getter(ListImageScanFindingAggregationsResponse::requestId)).setter(ListImageScanFindingAggregationsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> AGGREGATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationType").getter(ListImageScanFindingAggregationsResponse.getter(ListImageScanFindingAggregationsResponse::aggregationType)).setter(ListImageScanFindingAggregationsResponse.setter(Builder::aggregationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()}).build();
    private static final SdkField<List<ImageScanFindingAggregation>> RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("responses").getter(ListImageScanFindingAggregationsResponse.getter(ListImageScanFindingAggregationsResponse::responses)).setter(ListImageScanFindingAggregationsResponse.setter(Builder::responses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageScanFindingAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListImageScanFindingAggregationsResponse.getter(ListImageScanFindingAggregationsResponse::nextToken)).setter(ListImageScanFindingAggregationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, AGGREGATION_TYPE_FIELD, RESPONSES_FIELD, NEXT_TOKEN_FIELD));
    private final String requestIdValue;
    private final String aggregationType;
    private final List<ImageScanFindingAggregation> responses;
    private final String nextToken;

    private ListImageScanFindingAggregationsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.aggregationType = builder.aggregationType;
        this.responses = builder.responses;
        this.nextToken = builder.nextToken;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final String aggregationType() {
        return this.aggregationType;
    }

    public final boolean hasResponses() {
        return this.responses != null && !(this.responses instanceof SdkAutoConstructList);
    }

    public final List<ImageScanFindingAggregation> responses() {
        return this.responses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponses() ? this.responses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImageScanFindingAggregationsResponse)) {
            return false;
        }
        ListImageScanFindingAggregationsResponse other = (ListImageScanFindingAggregationsResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.aggregationType(), other.aggregationType()) && this.hasResponses() == other.hasResponses() && Objects.equals(this.responses(), other.responses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImageScanFindingAggregationsResponse").add("RequestId", (Object)this.requestId()).add("AggregationType", (Object)this.aggregationType()).add("Responses", this.hasResponses() ? this.responses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "aggregationType": {
                return Optional.ofNullable(clazz.cast(this.aggregationType()));
            }
            case "responses": {
                return Optional.ofNullable(clazz.cast(this.responses()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImageScanFindingAggregationsResponse, T> g) {
        return obj -> g.apply((ListImageScanFindingAggregationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String aggregationType;
        private List<ImageScanFindingAggregation> responses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImageScanFindingAggregationsResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.aggregationType(model.aggregationType);
            this.responses(model.responses);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getAggregationType() {
            return this.aggregationType;
        }

        public final void setAggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
        }

        @Override
        public final Builder aggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        public final List<ImageScanFindingAggregation.Builder> getResponses() {
            List<ImageScanFindingAggregation.Builder> result = ImageScanFindingAggregationsListCopier.copyToBuilder(this.responses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponses(Collection<ImageScanFindingAggregation.BuilderImpl> responses) {
            this.responses = ImageScanFindingAggregationsListCopier.copyFromBuilder(responses);
        }

        @Override
        public final Builder responses(Collection<ImageScanFindingAggregation> responses) {
            this.responses = ImageScanFindingAggregationsListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(ImageScanFindingAggregation ... responses) {
            this.responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(Consumer<ImageScanFindingAggregation.Builder> ... responses) {
            this.responses(Stream.of(responses).map(c -> (ImageScanFindingAggregation)((ImageScanFindingAggregation.Builder)ImageScanFindingAggregation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImageScanFindingAggregationsResponse build() {
            return new ListImageScanFindingAggregationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImageScanFindingAggregationsResponse> {
        public Builder requestId(String var1);

        public Builder aggregationType(String var1);

        public Builder responses(Collection<ImageScanFindingAggregation> var1);

        public Builder responses(ImageScanFindingAggregation ... var1);

        public Builder responses(Consumer<ImageScanFindingAggregation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

