/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.StringListCopier;
import software.amazon.awssdk.services.imagebuilder.model.TargetContainerRepository;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerDistributionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerDistributionConfiguration> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ContainerDistributionConfiguration.getter(ContainerDistributionConfiguration::description)).setter(ContainerDistributionConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> CONTAINER_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerTags").getter(ContainerDistributionConfiguration.getter(ContainerDistributionConfiguration::containerTags)).setter(ContainerDistributionConfiguration.setter(Builder::containerTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TargetContainerRepository> TARGET_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetRepository").getter(ContainerDistributionConfiguration.getter(ContainerDistributionConfiguration::targetRepository)).setter(ContainerDistributionConfiguration.setter(Builder::targetRepository)).constructor(TargetContainerRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRepository").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, CONTAINER_TAGS_FIELD, TARGET_REPOSITORY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final List<String> containerTags;
    private final TargetContainerRepository targetRepository;

    private ContainerDistributionConfiguration(BuilderImpl builder) {
        this.description = builder.description;
        this.containerTags = builder.containerTags;
        this.targetRepository = builder.targetRepository;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasContainerTags() {
        return this.containerTags != null && !(this.containerTags instanceof SdkAutoConstructList);
    }

    public final List<String> containerTags() {
        return this.containerTags;
    }

    public final TargetContainerRepository targetRepository() {
        return this.targetRepository;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerTags() ? this.containerTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRepository());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDistributionConfiguration)) {
            return false;
        }
        ContainerDistributionConfiguration other = (ContainerDistributionConfiguration)obj;
        return Objects.equals(this.description(), other.description()) && this.hasContainerTags() == other.hasContainerTags() && Objects.equals(this.containerTags(), other.containerTags()) && Objects.equals(this.targetRepository(), other.targetRepository());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerDistributionConfiguration").add("Description", (Object)this.description()).add("ContainerTags", this.hasContainerTags() ? this.containerTags() : null).add("TargetRepository", (Object)this.targetRepository()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "containerTags": {
                return Optional.ofNullable(clazz.cast(this.containerTags()));
            }
            case "targetRepository": {
                return Optional.ofNullable(clazz.cast(this.targetRepository()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDistributionConfiguration, T> g) {
        return obj -> g.apply((ContainerDistributionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<String> containerTags = DefaultSdkAutoConstructList.getInstance();
        private TargetContainerRepository targetRepository;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDistributionConfiguration model) {
            this.description(model.description);
            this.containerTags(model.containerTags);
            this.targetRepository(model.targetRepository);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getContainerTags() {
            if (this.containerTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerTags;
        }

        public final void setContainerTags(Collection<String> containerTags) {
            this.containerTags = StringListCopier.copy(containerTags);
        }

        @Override
        public final Builder containerTags(Collection<String> containerTags) {
            this.containerTags = StringListCopier.copy(containerTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerTags(String ... containerTags) {
            this.containerTags(Arrays.asList(containerTags));
            return this;
        }

        public final TargetContainerRepository.Builder getTargetRepository() {
            return this.targetRepository != null ? this.targetRepository.toBuilder() : null;
        }

        public final void setTargetRepository(TargetContainerRepository.BuilderImpl targetRepository) {
            this.targetRepository = targetRepository != null ? targetRepository.build() : null;
        }

        @Override
        public final Builder targetRepository(TargetContainerRepository targetRepository) {
            this.targetRepository = targetRepository;
            return this;
        }

        public ContainerDistributionConfiguration build() {
            return new ContainerDistributionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerDistributionConfiguration> {
        public Builder description(String var1);

        public Builder containerTags(Collection<String> var1);

        public Builder containerTags(String ... var1);

        public Builder targetRepository(TargetContainerRepository var1);

        default public Builder targetRepository(Consumer<TargetContainerRepository.Builder> targetRepository) {
            return this.targetRepository((TargetContainerRepository)((TargetContainerRepository.Builder)TargetContainerRepository.builder().applyMutation(targetRepository)).build());
        }
    }
}

