/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcrConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcrConfiguration> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(EcrConfiguration.getter(EcrConfiguration::repositoryName)).setter(EcrConfiguration.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<List<String>> CONTAINER_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerTags").getter(EcrConfiguration.getter(EcrConfiguration::containerTags)).setter(EcrConfiguration.setter(Builder::containerTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, CONTAINER_TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private final List<String> containerTags;

    private EcrConfiguration(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.containerTags = builder.containerTags;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final boolean hasContainerTags() {
        return this.containerTags != null && !(this.containerTags instanceof SdkAutoConstructList);
    }

    public final List<String> containerTags() {
        return this.containerTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerTags() ? this.containerTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcrConfiguration)) {
            return false;
        }
        EcrConfiguration other = (EcrConfiguration)obj;
        return Objects.equals(this.repositoryName(), other.repositoryName()) && this.hasContainerTags() == other.hasContainerTags() && Objects.equals(this.containerTags(), other.containerTags());
    }

    public final String toString() {
        return ToString.builder((String)"EcrConfiguration").add("RepositoryName", (Object)this.repositoryName()).add("ContainerTags", this.hasContainerTags() ? this.containerTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "containerTags": {
                return Optional.ofNullable(clazz.cast(this.containerTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcrConfiguration, T> g) {
        return obj -> g.apply((EcrConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryName;
        private List<String> containerTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EcrConfiguration model) {
            this.repositoryName(model.repositoryName);
            this.containerTags(model.containerTags);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final Collection<String> getContainerTags() {
            if (this.containerTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerTags;
        }

        public final void setContainerTags(Collection<String> containerTags) {
            this.containerTags = StringListCopier.copy(containerTags);
        }

        @Override
        public final Builder containerTags(Collection<String> containerTags) {
            this.containerTags = StringListCopier.copy(containerTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerTags(String ... containerTags) {
            this.containerTags(Arrays.asList(containerTags));
            return this;
        }

        public EcrConfiguration build() {
            return new EcrConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcrConfiguration> {
        public Builder repositoryName(String var1);

        public Builder containerTags(Collection<String> var1);

        public Builder containerTags(String ... var1);
    }
}

