/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContextKeyTypeEnum {
    STRING("string"),
    STRING_LIST("stringList"),
    NUMERIC("numeric"),
    NUMERIC_LIST("numericList"),
    BOOLEAN("boolean"),
    BOOLEAN_LIST("booleanList"),
    IP("ip"),
    IP_LIST("ipList"),
    BINARY("binary"),
    BINARY_LIST("binaryList"),
    DATE("date"),
    DATE_LIST("dateList"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContextKeyTypeEnum> VALUE_MAP;
    private final String value;

    private ContextKeyTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContextKeyTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContextKeyTypeEnum> knownValues() {
        EnumSet<ContextKeyTypeEnum> knownValues = EnumSet.allOf(ContextKeyTypeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContextKeyTypeEnum.class, ContextKeyTypeEnum::toString);
    }
}

