/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangePasswordRequest extends IamRequest implements
        ToCopyableBuilder<ChangePasswordRequest.Builder, ChangePasswordRequest> {
    private static final SdkField<String> OLD_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OldPassword").getter(getter(ChangePasswordRequest::oldPassword)).setter(setter(Builder::oldPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OldPassword").build()).build();

    private static final SdkField<String> NEW_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewPassword").getter(getter(ChangePasswordRequest::newPassword)).setter(setter(Builder::newPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OLD_PASSWORD_FIELD,
            NEW_PASSWORD_FIELD));

    private final String oldPassword;

    private final String newPassword;

    private ChangePasswordRequest(BuilderImpl builder) {
        super(builder);
        this.oldPassword = builder.oldPassword;
        this.newPassword = builder.newPassword;
    }

    /**
     * <p>
     * The IAM user's current password.
     * </p>
     * 
     * @return The IAM user's current password.
     */
    public final String oldPassword() {
        return oldPassword;
    }

    /**
     * <p>
     * The new password. The new password must conform to the Amazon Web Services account's password policy, if one
     * exists.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a
     * string of characters. That string can include almost any printable ASCII character from the space (<code>\u0020</code>
     * ) through the end of the ASCII character range (<code>\u00FF</code>). You can also include the tab (
     * <code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>) characters. Any
     * of these characters are valid in a password. However, many tools, such as the Amazon Web Services Management
     * Console, might restrict the ability to type certain characters because they have special meaning within that
     * tool.
     * </p>
     * 
     * @return The new password. The new password must conform to the Amazon Web Services account's password policy, if
     *         one exists.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter
     *         is a string of characters. That string can include almost any printable ASCII character from the space (
     *         <code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>). You can also
     *         include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     *         ) characters. Any of these characters are valid in a password. However, many tools, such as the Amazon
     *         Web Services Management Console, might restrict the ability to type certain characters because they have
     *         special meaning within that tool.
     */
    public final String newPassword() {
        return newPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(oldPassword());
        hashCode = 31 * hashCode + Objects.hashCode(newPassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangePasswordRequest)) {
            return false;
        }
        ChangePasswordRequest other = (ChangePasswordRequest) obj;
        return Objects.equals(oldPassword(), other.oldPassword()) && Objects.equals(newPassword(), other.newPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangePasswordRequest")
                .add("OldPassword", oldPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NewPassword", newPassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OldPassword":
            return Optional.ofNullable(clazz.cast(oldPassword()));
        case "NewPassword":
            return Optional.ofNullable(clazz.cast(newPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChangePasswordRequest, T> g) {
        return obj -> g.apply((ChangePasswordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, ChangePasswordRequest> {
        /**
         * <p>
         * The IAM user's current password.
         * </p>
         * 
         * @param oldPassword
         *        The IAM user's current password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldPassword(String oldPassword);

        /**
         * <p>
         * The new password. The new password must conform to the Amazon Web Services account's password policy, if one
         * exists.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a
         * string of characters. That string can include almost any printable ASCII character from the space (
         * <code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>). You can also include
         * the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
         * characters. Any of these characters are valid in a password. However, many tools, such as the Amazon Web
         * Services Management Console, might restrict the ability to type certain characters because they have special
         * meaning within that tool.
         * </p>
         * 
         * @param newPassword
         *        The new password. The new password must conform to the Amazon Web Services account's password policy,
         *        if one exists.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this
         *        parameter is a string of characters. That string can include almost any printable ASCII character from
         *        the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>).
         *        You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage
         *        return (<code>\u000D</code>) characters. Any of these characters are valid in a password. However,
         *        many tools, such as the Amazon Web Services Management Console, might restrict the ability to type
         *        certain characters because they have special meaning within that tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPassword(String newPassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String oldPassword;

        private String newPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangePasswordRequest model) {
            super(model);
            oldPassword(model.oldPassword);
            newPassword(model.newPassword);
        }

        public final String getOldPassword() {
            return oldPassword;
        }

        public final void setOldPassword(String oldPassword) {
            this.oldPassword = oldPassword;
        }

        @Override
        public final Builder oldPassword(String oldPassword) {
            this.oldPassword = oldPassword;
            return this;
        }

        public final String getNewPassword() {
            return newPassword;
        }

        public final void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        @Override
        public final Builder newPassword(String newPassword) {
            this.newPassword = newPassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangePasswordRequest build() {
            return new ChangePasswordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
