/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.honeycode.HoneycodeClient;
import software.amazon.awssdk.services.honeycode.internal.UserAgentUtils;
import software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest;
import software.amazon.awssdk.services.honeycode.model.ListTableColumnsResponse;
import software.amazon.awssdk.services.honeycode.model.TableColumn;

public class ListTableColumnsIterable
implements SdkIterable<ListTableColumnsResponse> {
    private final HoneycodeClient client;
    private final ListTableColumnsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTableColumnsIterable(HoneycodeClient client, ListTableColumnsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTableColumnsResponseFetcher();
    }

    public Iterator<ListTableColumnsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TableColumn> tableColumns() {
        Function<ListTableColumnsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableColumns() != null) {
                return response.tableColumns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTableColumnsResponseFetcher
    implements SyncPageFetcher<ListTableColumnsResponse> {
        private ListTableColumnsResponseFetcher() {
        }

        public boolean hasNextPage(ListTableColumnsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTableColumnsResponse nextPage(ListTableColumnsResponse previousPage) {
            if (previousPage == null) {
                return ListTableColumnsIterable.this.client.listTableColumns(ListTableColumnsIterable.this.firstRequest);
            }
            return ListTableColumnsIterable.this.client.listTableColumns((ListTableColumnsRequest)((Object)ListTableColumnsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

