/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.Container;
import software.amazon.awssdk.services.guardduty.model.ContainersCopier;
import software.amazon.awssdk.services.guardduty.model.Tag;
import software.amazon.awssdk.services.guardduty.model.TagsCopier;
import software.amazon.awssdk.services.guardduty.model.Volume;
import software.amazon.awssdk.services.guardduty.model.VolumesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsTaskDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsTaskDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(EcsTaskDetails.getter(EcsTaskDetails::arn)).setter(EcsTaskDetails.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefinitionArn").getter(EcsTaskDetails.getter(EcsTaskDetails::definitionArn)).setter(EcsTaskDetails.setter(Builder::definitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionArn").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(EcsTaskDetails.getter(EcsTaskDetails::version)).setter(EcsTaskDetails.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> TASK_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TaskCreatedAt").getter(EcsTaskDetails.getter(EcsTaskDetails::taskCreatedAt)).setter(EcsTaskDetails.setter(Builder::taskCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(EcsTaskDetails.getter(EcsTaskDetails::startedAt)).setter(EcsTaskDetails.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartedBy").getter(EcsTaskDetails.getter(EcsTaskDetails::startedBy)).setter(EcsTaskDetails.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(EcsTaskDetails.getter(EcsTaskDetails::tags)).setter(EcsTaskDetails.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Volumes").getter(EcsTaskDetails.getter(EcsTaskDetails::volumes)).setter(EcsTaskDetails.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Volume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Container>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Containers").getter(EcsTaskDetails.getter(EcsTaskDetails::containers)).setter(EcsTaskDetails.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Container::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(EcsTaskDetails.getter(EcsTaskDetails::group)).setter(EcsTaskDetails.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DEFINITION_ARN_FIELD, VERSION_FIELD, TASK_CREATED_AT_FIELD, STARTED_AT_FIELD, STARTED_BY_FIELD, TAGS_FIELD, VOLUMES_FIELD, CONTAINERS_FIELD, GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String definitionArn;
    private final String version;
    private final Instant taskCreatedAt;
    private final Instant startedAt;
    private final String startedBy;
    private final List<Tag> tags;
    private final List<Volume> volumes;
    private final List<Container> containers;
    private final String group;

    private EcsTaskDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.definitionArn = builder.definitionArn;
        this.version = builder.version;
        this.taskCreatedAt = builder.taskCreatedAt;
        this.startedAt = builder.startedAt;
        this.startedBy = builder.startedBy;
        this.tags = builder.tags;
        this.volumes = builder.volumes;
        this.containers = builder.containers;
        this.group = builder.group;
    }

    public final String arn() {
        return this.arn;
    }

    public final String definitionArn() {
        return this.definitionArn;
    }

    public final String version() {
        return this.version;
    }

    public final Instant taskCreatedAt() {
        return this.taskCreatedAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final String startedBy() {
        return this.startedBy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasVolumes() {
        return this.volumes != null && !(this.volumes instanceof SdkAutoConstructList);
    }

    public final List<Volume> volumes() {
        return this.volumes;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<Container> containers() {
        return this.containers;
    }

    public final String group() {
        return this.group;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumes() ? this.volumes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsTaskDetails)) {
            return false;
        }
        EcsTaskDetails other = (EcsTaskDetails)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.definitionArn(), other.definitionArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.taskCreatedAt(), other.taskCreatedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.startedBy(), other.startedBy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasVolumes() == other.hasVolumes() && Objects.equals(this.volumes(), other.volumes()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && Objects.equals(this.group(), other.group());
    }

    public final String toString() {
        return ToString.builder((String)"EcsTaskDetails").add("Arn", (Object)this.arn()).add("DefinitionArn", (Object)this.definitionArn()).add("Version", (Object)this.version()).add("TaskCreatedAt", (Object)this.taskCreatedAt()).add("StartedAt", (Object)this.startedAt()).add("StartedBy", (Object)this.startedBy()).add("Tags", this.hasTags() ? this.tags() : null).add("Volumes", this.hasVolumes() ? this.volumes() : null).add("Containers", this.hasContainers() ? this.containers() : null).add("Group", (Object)this.group()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.definitionArn()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "TaskCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.taskCreatedAt()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "StartedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
            case "Containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcsTaskDetails, T> g) {
        return obj -> g.apply((EcsTaskDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String definitionArn;
        private String version;
        private Instant taskCreatedAt;
        private Instant startedAt;
        private String startedBy;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();
        private List<Container> containers = DefaultSdkAutoConstructList.getInstance();
        private String group;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsTaskDetails model) {
            this.arn(model.arn);
            this.definitionArn(model.definitionArn);
            this.version(model.version);
            this.taskCreatedAt(model.taskCreatedAt);
            this.startedAt(model.startedAt);
            this.startedBy(model.startedBy);
            this.tags(model.tags);
            this.volumes(model.volumes);
            this.containers(model.containers);
            this.group(model.group);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDefinitionArn() {
            return this.definitionArn;
        }

        public final void setDefinitionArn(String definitionArn) {
            this.definitionArn = definitionArn;
        }

        @Override
        public final Builder definitionArn(String definitionArn) {
            this.definitionArn = definitionArn;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getTaskCreatedAt() {
            return this.taskCreatedAt;
        }

        public final void setTaskCreatedAt(Instant taskCreatedAt) {
            this.taskCreatedAt = taskCreatedAt;
        }

        @Override
        public final Builder taskCreatedAt(Instant taskCreatedAt) {
            this.taskCreatedAt = taskCreatedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (Volume)((Volume.Builder)Volume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Container.Builder> getContainers() {
            List<Container.Builder> result = ContainersCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<Container.BuilderImpl> containers) {
            this.containers = ContainersCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<Container> containers) {
            this.containers = ContainersCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Container ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<Container.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (Container)((Container.Builder)Container.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public EcsTaskDetails build() {
            return new EcsTaskDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsTaskDetails> {
        public Builder arn(String var1);

        public Builder definitionArn(String var1);

        public Builder version(String var1);

        public Builder taskCreatedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder startedBy(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder volumes(Consumer<Volume.Builder> ... var1);

        public Builder containers(Collection<Container> var1);

        public Builder containers(Container ... var1);

        public Builder containers(Consumer<Container.Builder> ... var1);

        public Builder group(String var1);
    }
}

