/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptInvitationRequest extends GuardDutyRequest implements
        ToCopyableBuilder<AcceptInvitationRequest.Builder, AcceptInvitationRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(AcceptInvitationRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<String> MASTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterId").getter(getter(AcceptInvitationRequest::masterId)).setter(setter(Builder::masterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterId").build()).build();

    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvitationId").getter(getter(AcceptInvitationRequest::invitationId))
            .setter(setter(Builder::invitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            MASTER_ID_FIELD, INVITATION_ID_FIELD));

    private final String detectorId;

    private final String masterId;

    private final String invitationId;

    private AcceptInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.masterId = builder.masterId;
        this.invitationId = builder.invitationId;
    }

    /**
     * <p>
     * The unique ID of the detector of the GuardDuty member account.
     * </p>
     * 
     * @return The unique ID of the detector of the GuardDuty member account.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The account ID of the GuardDuty administrator account whose invitation you're accepting.
     * </p>
     * 
     * @return The account ID of the GuardDuty administrator account whose invitation you're accepting.
     */
    public final String masterId() {
        return masterId;
    }

    /**
     * <p>
     * The value that is used to validate the administrator account to the member account.
     * </p>
     * 
     * @return The value that is used to validate the administrator account to the member account.
     */
    public final String invitationId() {
        return invitationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(masterId());
        hashCode = 31 * hashCode + Objects.hashCode(invitationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptInvitationRequest)) {
            return false;
        }
        AcceptInvitationRequest other = (AcceptInvitationRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(masterId(), other.masterId())
                && Objects.equals(invitationId(), other.invitationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptInvitationRequest").add("DetectorId", detectorId()).add("MasterId", masterId())
                .add("InvitationId", invitationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "MasterId":
            return Optional.ofNullable(clazz.cast(masterId()));
        case "InvitationId":
            return Optional.ofNullable(clazz.cast(invitationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptInvitationRequest, T> g) {
        return obj -> g.apply((AcceptInvitationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, AcceptInvitationRequest> {
        /**
         * <p>
         * The unique ID of the detector of the GuardDuty member account.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the detector of the GuardDuty member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The account ID of the GuardDuty administrator account whose invitation you're accepting.
         * </p>
         * 
         * @param masterId
         *        The account ID of the GuardDuty administrator account whose invitation you're accepting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterId(String masterId);

        /**
         * <p>
         * The value that is used to validate the administrator account to the member account.
         * </p>
         * 
         * @param invitationId
         *        The value that is used to validate the administrator account to the member account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitationId(String invitationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String masterId;

        private String invitationId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptInvitationRequest model) {
            super(model);
            detectorId(model.detectorId);
            masterId(model.masterId);
            invitationId(model.invitationId);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getMasterId() {
            return masterId;
        }

        public final void setMasterId(String masterId) {
            this.masterId = masterId;
        }

        @Override
        public final Builder masterId(String masterId) {
            this.masterId = masterId;
            return this;
        }

        public final String getInvitationId() {
            return invitationId;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptInvitationRequest build() {
            return new AcceptInvitationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
