/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.LocalIpDetails;
import software.amazon.awssdk.services.guardduty.model.LocalPortDetails;
import software.amazon.awssdk.services.guardduty.model.RemoteIpDetails;
import software.amazon.awssdk.services.guardduty.model.RemotePortDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkConnectionAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkConnectionAction> {
    private static final SdkField<Boolean> BLOCKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Blocked").getter(NetworkConnectionAction.getter(NetworkConnectionAction::blocked)).setter(NetworkConnectionAction.setter(Builder::blocked)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blocked").build()}).build();
    private static final SdkField<String> CONNECTION_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionDirection").getter(NetworkConnectionAction.getter(NetworkConnectionAction::connectionDirection)).setter(NetworkConnectionAction.setter(Builder::connectionDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionDirection").build()}).build();
    private static final SdkField<LocalPortDetails> LOCAL_PORT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocalPortDetails").getter(NetworkConnectionAction.getter(NetworkConnectionAction::localPortDetails)).setter(NetworkConnectionAction.setter(Builder::localPortDetails)).constructor(LocalPortDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localPortDetails").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(NetworkConnectionAction.getter(NetworkConnectionAction::protocol)).setter(NetworkConnectionAction.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<LocalIpDetails> LOCAL_IP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocalIpDetails").getter(NetworkConnectionAction.getter(NetworkConnectionAction::localIpDetails)).setter(NetworkConnectionAction.setter(Builder::localIpDetails)).constructor(LocalIpDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localIpDetails").build()}).build();
    private static final SdkField<RemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteIpDetails").getter(NetworkConnectionAction.getter(NetworkConnectionAction::remoteIpDetails)).setter(NetworkConnectionAction.setter(Builder::remoteIpDetails)).constructor(RemoteIpDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIpDetails").build()}).build();
    private static final SdkField<RemotePortDetails> REMOTE_PORT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemotePortDetails").getter(NetworkConnectionAction.getter(NetworkConnectionAction::remotePortDetails)).setter(NetworkConnectionAction.setter(Builder::remotePortDetails)).constructor(RemotePortDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remotePortDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_FIELD, CONNECTION_DIRECTION_FIELD, LOCAL_PORT_DETAILS_FIELD, PROTOCOL_FIELD, LOCAL_IP_DETAILS_FIELD, REMOTE_IP_DETAILS_FIELD, REMOTE_PORT_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean blocked;
    private final String connectionDirection;
    private final LocalPortDetails localPortDetails;
    private final String protocol;
    private final LocalIpDetails localIpDetails;
    private final RemoteIpDetails remoteIpDetails;
    private final RemotePortDetails remotePortDetails;

    private NetworkConnectionAction(BuilderImpl builder) {
        this.blocked = builder.blocked;
        this.connectionDirection = builder.connectionDirection;
        this.localPortDetails = builder.localPortDetails;
        this.protocol = builder.protocol;
        this.localIpDetails = builder.localIpDetails;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.remotePortDetails = builder.remotePortDetails;
    }

    public final Boolean blocked() {
        return this.blocked;
    }

    public final String connectionDirection() {
        return this.connectionDirection;
    }

    public final LocalPortDetails localPortDetails() {
        return this.localPortDetails;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final LocalIpDetails localIpDetails() {
        return this.localIpDetails;
    }

    public final RemoteIpDetails remoteIpDetails() {
        return this.remoteIpDetails;
    }

    public final RemotePortDetails remotePortDetails() {
        return this.remotePortDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blocked());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionDirection());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPortDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.localIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.remotePortDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConnectionAction)) {
            return false;
        }
        NetworkConnectionAction other = (NetworkConnectionAction)obj;
        return Objects.equals(this.blocked(), other.blocked()) && Objects.equals(this.connectionDirection(), other.connectionDirection()) && Objects.equals(this.localPortDetails(), other.localPortDetails()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.localIpDetails(), other.localIpDetails()) && Objects.equals(this.remoteIpDetails(), other.remoteIpDetails()) && Objects.equals(this.remotePortDetails(), other.remotePortDetails());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkConnectionAction").add("Blocked", (Object)this.blocked()).add("ConnectionDirection", (Object)this.connectionDirection()).add("LocalPortDetails", (Object)this.localPortDetails()).add("Protocol", (Object)this.protocol()).add("LocalIpDetails", (Object)this.localIpDetails()).add("RemoteIpDetails", (Object)this.remoteIpDetails()).add("RemotePortDetails", (Object)this.remotePortDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Blocked": {
                return Optional.ofNullable(clazz.cast(this.blocked()));
            }
            case "ConnectionDirection": {
                return Optional.ofNullable(clazz.cast(this.connectionDirection()));
            }
            case "LocalPortDetails": {
                return Optional.ofNullable(clazz.cast(this.localPortDetails()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "LocalIpDetails": {
                return Optional.ofNullable(clazz.cast(this.localIpDetails()));
            }
            case "RemoteIpDetails": {
                return Optional.ofNullable(clazz.cast(this.remoteIpDetails()));
            }
            case "RemotePortDetails": {
                return Optional.ofNullable(clazz.cast(this.remotePortDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkConnectionAction, T> g) {
        return obj -> g.apply((NetworkConnectionAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean blocked;
        private String connectionDirection;
        private LocalPortDetails localPortDetails;
        private String protocol;
        private LocalIpDetails localIpDetails;
        private RemoteIpDetails remoteIpDetails;
        private RemotePortDetails remotePortDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConnectionAction model) {
            this.blocked(model.blocked);
            this.connectionDirection(model.connectionDirection);
            this.localPortDetails(model.localPortDetails);
            this.protocol(model.protocol);
            this.localIpDetails(model.localIpDetails);
            this.remoteIpDetails(model.remoteIpDetails);
            this.remotePortDetails(model.remotePortDetails);
        }

        public final Boolean getBlocked() {
            return this.blocked;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        @Override
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public final String getConnectionDirection() {
            return this.connectionDirection;
        }

        public final void setConnectionDirection(String connectionDirection) {
            this.connectionDirection = connectionDirection;
        }

        @Override
        public final Builder connectionDirection(String connectionDirection) {
            this.connectionDirection = connectionDirection;
            return this;
        }

        public final LocalPortDetails.Builder getLocalPortDetails() {
            return this.localPortDetails != null ? this.localPortDetails.toBuilder() : null;
        }

        public final void setLocalPortDetails(LocalPortDetails.BuilderImpl localPortDetails) {
            this.localPortDetails = localPortDetails != null ? localPortDetails.build() : null;
        }

        @Override
        public final Builder localPortDetails(LocalPortDetails localPortDetails) {
            this.localPortDetails = localPortDetails;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final LocalIpDetails.Builder getLocalIpDetails() {
            return this.localIpDetails != null ? this.localIpDetails.toBuilder() : null;
        }

        public final void setLocalIpDetails(LocalIpDetails.BuilderImpl localIpDetails) {
            this.localIpDetails = localIpDetails != null ? localIpDetails.build() : null;
        }

        @Override
        public final Builder localIpDetails(LocalIpDetails localIpDetails) {
            this.localIpDetails = localIpDetails;
            return this;
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return this.remoteIpDetails != null ? this.remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final RemotePortDetails.Builder getRemotePortDetails() {
            return this.remotePortDetails != null ? this.remotePortDetails.toBuilder() : null;
        }

        public final void setRemotePortDetails(RemotePortDetails.BuilderImpl remotePortDetails) {
            this.remotePortDetails = remotePortDetails != null ? remotePortDetails.build() : null;
        }

        @Override
        public final Builder remotePortDetails(RemotePortDetails remotePortDetails) {
            this.remotePortDetails = remotePortDetails;
            return this;
        }

        public NetworkConnectionAction build() {
            return new NetworkConnectionAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkConnectionAction> {
        public Builder blocked(Boolean var1);

        public Builder connectionDirection(String var1);

        public Builder localPortDetails(LocalPortDetails var1);

        default public Builder localPortDetails(Consumer<LocalPortDetails.Builder> localPortDetails) {
            return this.localPortDetails((LocalPortDetails)((LocalPortDetails.Builder)LocalPortDetails.builder().applyMutation(localPortDetails)).build());
        }

        public Builder protocol(String var1);

        public Builder localIpDetails(LocalIpDetails var1);

        default public Builder localIpDetails(Consumer<LocalIpDetails.Builder> localIpDetails) {
            return this.localIpDetails((LocalIpDetails)((LocalIpDetails.Builder)LocalIpDetails.builder().applyMutation(localIpDetails)).build());
        }

        public Builder remoteIpDetails(RemoteIpDetails var1);

        default public Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return this.remoteIpDetails((RemoteIpDetails)((RemoteIpDetails.Builder)RemoteIpDetails.builder().applyMutation(remoteIpDetails)).build());
        }

        public Builder remotePortDetails(RemotePortDetails var1);

        default public Builder remotePortDetails(Consumer<RemotePortDetails.Builder> remotePortDetails) {
            return this.remotePortDetails((RemotePortDetails)((RemotePortDetails.Builder)RemotePortDetails.builder().applyMutation(remotePortDetails)).build());
        }
    }
}

