/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.DescribeEntityRequest;
import software.amazon.awssdk.services.glue.model.DescribeEntityResponse;
import software.amazon.awssdk.services.glue.model.Field;

public class DescribeEntityPublisher
implements SdkPublisher<DescribeEntityResponse> {
    private final GlueAsyncClient client;
    private final DescribeEntityRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEntityPublisher(GlueAsyncClient client, DescribeEntityRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEntityPublisher(GlueAsyncClient client, DescribeEntityRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEntityResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEntityResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Field> fields() {
        Function<DescribeEntityResponse, Iterator> getIterator = response -> {
            if (response != null && response.fields() != null) {
                return response.fields().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEntityResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEntityResponseFetcher
    implements AsyncPageFetcher<DescribeEntityResponse> {
        private DescribeEntityResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEntityResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEntityResponse> nextPage(DescribeEntityResponse previousPage) {
            if (previousPage == null) {
                return DescribeEntityPublisher.this.client.describeEntity(DescribeEntityPublisher.this.firstRequest);
            }
            return DescribeEntityPublisher.this.client.describeEntity((DescribeEntityRequest)((Object)DescribeEntityPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

