/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.IcebergSortField;
import software.amazon.awssdk.services.glue.model.IcebergSortOrderFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergSortOrder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergSortOrder> {
    private static final SdkField<Integer> ORDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OrderId").getter(IcebergSortOrder.getter(IcebergSortOrder::orderId)).setter(IcebergSortOrder.setter(Builder::orderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderId").build()}).build();
    private static final SdkField<List<IcebergSortField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fields").getter(IcebergSortOrder.getter(IcebergSortOrder::fields)).setter(IcebergSortOrder.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IcebergSortField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDER_ID_FIELD, FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergSortOrder.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer orderId;
    private final List<IcebergSortField> fields;

    private IcebergSortOrder(BuilderImpl builder) {
        this.orderId = builder.orderId;
        this.fields = builder.fields;
    }

    public final Integer orderId() {
        return this.orderId;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<IcebergSortField> fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.orderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergSortOrder)) {
            return false;
        }
        IcebergSortOrder other = (IcebergSortOrder)obj;
        return Objects.equals(this.orderId(), other.orderId()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergSortOrder").add("OrderId", (Object)this.orderId()).add("Fields", this.hasFields() ? this.fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrderId": {
                return Optional.ofNullable(clazz.cast(this.orderId()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrderId", ORDER_ID_FIELD);
        map.put("Fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergSortOrder, T> g) {
        return obj -> g.apply((IcebergSortOrder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer orderId;
        private List<IcebergSortField> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergSortOrder model) {
            this.orderId(model.orderId);
            this.fields(model.fields);
        }

        public final Integer getOrderId() {
            return this.orderId;
        }

        public final void setOrderId(Integer orderId) {
            this.orderId = orderId;
        }

        @Override
        public final Builder orderId(Integer orderId) {
            this.orderId = orderId;
            return this;
        }

        public final List<IcebergSortField.Builder> getFields() {
            List<IcebergSortField.Builder> result = IcebergSortOrderFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<IcebergSortField.BuilderImpl> fields) {
            this.fields = IcebergSortOrderFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<IcebergSortField> fields) {
            this.fields = IcebergSortOrderFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(IcebergSortField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<IcebergSortField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (IcebergSortField)((IcebergSortField.Builder)IcebergSortField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IcebergSortOrder build() {
            return new IcebergSortOrder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergSortOrder> {
        public Builder orderId(Integer var1);

        public Builder fields(Collection<IcebergSortField> var1);

        public Builder fields(IcebergSortField ... var1);

        public Builder fields(Consumer<IcebergSortField.Builder> ... var1);
    }
}

