/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.GetTableVersionsRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionsResponse;

public class GetTableVersionsPublisher
implements SdkPublisher<GetTableVersionsResponse> {
    private final GlueAsyncClient client;
    private final GetTableVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTableVersionsPublisher(GlueAsyncClient client, GetTableVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTableVersionsPublisher(GlueAsyncClient client, GetTableVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTableVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTableVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetTableVersionsResponseFetcher
    implements AsyncPageFetcher<GetTableVersionsResponse> {
        private GetTableVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetTableVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTableVersionsResponse> nextPage(GetTableVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetTableVersionsPublisher.this.client.getTableVersions(GetTableVersionsPublisher.this.firstRequest);
            }
            return GetTableVersionsPublisher.this.client.getTableVersions((GetTableVersionsRequest)((Object)GetTableVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

