/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DataQualityRulesetListCopier;
import software.amazon.awssdk.services.glue.model.DataQualityRulesetListDetails;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataQualityRulesetsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListDataQualityRulesetsResponse> {
    private static final SdkField<List<DataQualityRulesetListDetails>> RULESETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rulesets").getter(ListDataQualityRulesetsResponse.getter(ListDataQualityRulesetsResponse::rulesets)).setter(ListDataQualityRulesetsResponse.setter(Builder::rulesets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rulesets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataQualityRulesetListDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataQualityRulesetsResponse.getter(ListDataQualityRulesetsResponse::nextToken)).setter(ListDataQualityRulesetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULESETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataQualityRulesetsResponse.memberNameToFieldInitializer();
    private final List<DataQualityRulesetListDetails> rulesets;
    private final String nextToken;

    private ListDataQualityRulesetsResponse(BuilderImpl builder) {
        super(builder);
        this.rulesets = builder.rulesets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRulesets() {
        return this.rulesets != null && !(this.rulesets instanceof SdkAutoConstructList);
    }

    public final List<DataQualityRulesetListDetails> rulesets() {
        return this.rulesets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRulesets() ? this.rulesets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataQualityRulesetsResponse)) {
            return false;
        }
        ListDataQualityRulesetsResponse other = (ListDataQualityRulesetsResponse)((Object)obj);
        return this.hasRulesets() == other.hasRulesets() && Objects.equals(this.rulesets(), other.rulesets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataQualityRulesetsResponse").add("Rulesets", this.hasRulesets() ? this.rulesets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rulesets": {
                return Optional.ofNullable(clazz.cast(this.rulesets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Rulesets", RULESETS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataQualityRulesetsResponse, T> g) {
        return obj -> g.apply((ListDataQualityRulesetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<DataQualityRulesetListDetails> rulesets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataQualityRulesetsResponse model) {
            super(model);
            this.rulesets(model.rulesets);
            this.nextToken(model.nextToken);
        }

        public final List<DataQualityRulesetListDetails.Builder> getRulesets() {
            List<DataQualityRulesetListDetails.Builder> result = DataQualityRulesetListCopier.copyToBuilder(this.rulesets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRulesets(Collection<DataQualityRulesetListDetails.BuilderImpl> rulesets) {
            this.rulesets = DataQualityRulesetListCopier.copyFromBuilder(rulesets);
        }

        @Override
        public final Builder rulesets(Collection<DataQualityRulesetListDetails> rulesets) {
            this.rulesets = DataQualityRulesetListCopier.copy(rulesets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesets(DataQualityRulesetListDetails ... rulesets) {
            this.rulesets(Arrays.asList(rulesets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesets(Consumer<DataQualityRulesetListDetails.Builder> ... rulesets) {
            this.rulesets(Stream.of(rulesets).map(c -> (DataQualityRulesetListDetails)((DataQualityRulesetListDetails.Builder)DataQualityRulesetListDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataQualityRulesetsResponse build() {
            return new ListDataQualityRulesetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataQualityRulesetsResponse> {
        public Builder rulesets(Collection<DataQualityRulesetListDetails> var1);

        public Builder rulesets(DataQualityRulesetListDetails ... var1);

        public Builder rulesets(Consumer<DataQualityRulesetListDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

