/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.WorkflowRun;
import software.amazon.awssdk.services.glue.model.WorkflowRunsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowRunsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetWorkflowRunsResponse> {
    private static final SdkField<List<WorkflowRun>> RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Runs").getter(GetWorkflowRunsResponse.getter(GetWorkflowRunsResponse::runs)).setter(GetWorkflowRunsResponse.setter(Builder::runs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetWorkflowRunsResponse.getter(GetWorkflowRunsResponse::nextToken)).setter(GetWorkflowRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkflowRunsResponse.memberNameToFieldInitializer();
    private final List<WorkflowRun> runs;
    private final String nextToken;

    private GetWorkflowRunsResponse(BuilderImpl builder) {
        super(builder);
        this.runs = builder.runs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRuns() {
        return this.runs != null && !(this.runs instanceof SdkAutoConstructList);
    }

    public final List<WorkflowRun> runs() {
        return this.runs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuns() ? this.runs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRunsResponse)) {
            return false;
        }
        GetWorkflowRunsResponse other = (GetWorkflowRunsResponse)((Object)obj);
        return this.hasRuns() == other.hasRuns() && Objects.equals(this.runs(), other.runs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowRunsResponse").add("Runs", this.hasRuns() ? this.runs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Runs": {
                return Optional.ofNullable(clazz.cast(this.runs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Runs", RUNS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRunsResponse, T> g) {
        return obj -> g.apply((GetWorkflowRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<WorkflowRun> runs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRunsResponse model) {
            super(model);
            this.runs(model.runs);
            this.nextToken(model.nextToken);
        }

        public final List<WorkflowRun.Builder> getRuns() {
            List<WorkflowRun.Builder> result = WorkflowRunsCopier.copyToBuilder(this.runs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuns(Collection<WorkflowRun.BuilderImpl> runs) {
            this.runs = WorkflowRunsCopier.copyFromBuilder(runs);
        }

        @Override
        public final Builder runs(Collection<WorkflowRun> runs) {
            this.runs = WorkflowRunsCopier.copy(runs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(WorkflowRun ... runs) {
            this.runs(Arrays.asList(runs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(Consumer<WorkflowRun.Builder> ... runs) {
            this.runs(Stream.of(runs).map(c -> (WorkflowRun)((WorkflowRun.Builder)WorkflowRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetWorkflowRunsResponse build() {
            return new GetWorkflowRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowRunsResponse> {
        public Builder runs(Collection<WorkflowRun> var1);

        public Builder runs(WorkflowRun ... var1);

        public Builder runs(Consumer<WorkflowRun.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

