/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CsvHeaderOption {
    UNKNOWN("UNKNOWN"),
    PRESENT("PRESENT"),
    ABSENT("ABSENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CsvHeaderOption> VALUE_MAP;
    private final String value;

    private CsvHeaderOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CsvHeaderOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CsvHeaderOption> knownValues() {
        EnumSet<CsvHeaderOption> knownValues = EnumSet.allOf(CsvHeaderOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CsvHeaderOption.class, CsvHeaderOption::toString);
    }
}

