/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComputeEnvironment {
    SPARK("SPARK"),
    ATHENA("ATHENA"),
    PYTHON("PYTHON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComputeEnvironment> VALUE_MAP;
    private final String value;

    private ComputeEnvironment(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComputeEnvironment fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComputeEnvironment> knownValues() {
        EnumSet<ComputeEnvironment> knownValues = EnumSet.allOf(ComputeEnvironment.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComputeEnvironment.class, ComputeEnvironment::toString);
    }
}

