/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.TableOptimizerConfiguration;
import software.amazon.awssdk.services.glue.model.TableOptimizerRun;
import software.amazon.awssdk.services.glue.model.TableOptimizerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableOptimizer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableOptimizer> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(TableOptimizer.getter(TableOptimizer::typeAsString)).setter(TableOptimizer.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<TableOptimizerConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(TableOptimizer.getter(TableOptimizer::configuration)).setter(TableOptimizer.setter(Builder::configuration)).constructor(TableOptimizerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<TableOptimizerRun> LAST_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastRun").getter(TableOptimizer.getter(TableOptimizer::lastRun)).setter(TableOptimizer.setter(Builder::lastRun)).constructor(TableOptimizerRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONFIGURATION_FIELD, LAST_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TableOptimizer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final TableOptimizerConfiguration configuration;
    private final TableOptimizerRun lastRun;

    private TableOptimizer(BuilderImpl builder) {
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.lastRun = builder.lastRun;
    }

    public final TableOptimizerType type() {
        return TableOptimizerType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final TableOptimizerConfiguration configuration() {
        return this.configuration;
    }

    public final TableOptimizerRun lastRun() {
        return this.lastRun;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableOptimizer)) {
            return false;
        }
        TableOptimizer other = (TableOptimizer)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.lastRun(), other.lastRun());
    }

    public final String toString() {
        return ToString.builder((String)"TableOptimizer").add("Type", (Object)this.typeAsString()).add("Configuration", (Object)this.configuration()).add("LastRun", (Object)this.lastRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "lastRun": {
                return Optional.ofNullable(clazz.cast(this.lastRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("lastRun", LAST_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableOptimizer, T> g) {
        return obj -> g.apply((TableOptimizer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private TableOptimizerConfiguration configuration;
        private TableOptimizerRun lastRun;

        private BuilderImpl() {
        }

        private BuilderImpl(TableOptimizer model) {
            this.type(model.type);
            this.configuration(model.configuration);
            this.lastRun(model.lastRun);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TableOptimizerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final TableOptimizerConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(TableOptimizerConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(TableOptimizerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final TableOptimizerRun.Builder getLastRun() {
            return this.lastRun != null ? this.lastRun.toBuilder() : null;
        }

        public final void setLastRun(TableOptimizerRun.BuilderImpl lastRun) {
            this.lastRun = lastRun != null ? lastRun.build() : null;
        }

        @Override
        public final Builder lastRun(TableOptimizerRun lastRun) {
            this.lastRun = lastRun;
            return this;
        }

        public TableOptimizer build() {
            return new TableOptimizer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableOptimizer> {
        public Builder type(String var1);

        public Builder type(TableOptimizerType var1);

        public Builder configuration(TableOptimizerConfiguration var1);

        default public Builder configuration(Consumer<TableOptimizerConfiguration.Builder> configuration) {
            return this.configuration((TableOptimizerConfiguration)((TableOptimizerConfiguration.Builder)TableOptimizerConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder lastRun(TableOptimizerRun var1);

        default public Builder lastRun(Consumer<TableOptimizerRun.Builder> lastRun) {
            return this.lastRun((TableOptimizerRun)((TableOptimizerRun.Builder)TableOptimizerRun.builder().applyMutation(lastRun)).build());
        }
    }
}

