/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.Datatype;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NullValueField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NullValueField> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(NullValueField.getter(NullValueField::value)).setter(NullValueField.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Datatype> DATATYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Datatype").getter(NullValueField.getter(NullValueField::datatype)).setter(NullValueField.setter(Builder::datatype)).constructor(Datatype::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datatype").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, DATATYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NullValueField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Datatype datatype;

    private NullValueField(BuilderImpl builder) {
        this.value = builder.value;
        this.datatype = builder.datatype;
    }

    public final String value() {
        return this.value;
    }

    public final Datatype datatype() {
        return this.datatype;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.datatype());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NullValueField)) {
            return false;
        }
        NullValueField other = (NullValueField)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.datatype(), other.datatype());
    }

    public final String toString() {
        return ToString.builder((String)"NullValueField").add("Value", (Object)this.value()).add("Datatype", (Object)this.datatype()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Datatype": {
                return Optional.ofNullable(clazz.cast(this.datatype()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Value", VALUE_FIELD);
        map.put("Datatype", DATATYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NullValueField, T> g) {
        return obj -> g.apply((NullValueField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private Datatype datatype;

        private BuilderImpl() {
        }

        private BuilderImpl(NullValueField model) {
            this.value(model.value);
            this.datatype(model.datatype);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Datatype.Builder getDatatype() {
            return this.datatype != null ? this.datatype.toBuilder() : null;
        }

        public final void setDatatype(Datatype.BuilderImpl datatype) {
            this.datatype = datatype != null ? datatype.build() : null;
        }

        @Override
        public final Builder datatype(Datatype datatype) {
            this.datatype = datatype;
            return this;
        }

        public NullValueField build() {
            return new NullValueField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NullValueField> {
        public Builder value(String var1);

        public Builder datatype(Datatype var1);

        default public Builder datatype(Consumer<Datatype.Builder> datatype) {
            return this.datatype((Datatype)((Datatype.Builder)Datatype.builder().applyMutation(datatype)).build());
        }
    }
}

