/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.Workflow;
import software.amazon.awssdk.services.glue.model.WorkflowNamesCopier;
import software.amazon.awssdk.services.glue.model.WorkflowsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetWorkflowsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchGetWorkflowsResponse> {
    private static final SdkField<List<Workflow>> WORKFLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Workflows").getter(BatchGetWorkflowsResponse.getter(BatchGetWorkflowsResponse::workflows)).setter(BatchGetWorkflowsResponse.setter(Builder::workflows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Workflow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MISSING_WORKFLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MissingWorkflows").getter(BatchGetWorkflowsResponse.getter(BatchGetWorkflowsResponse::missingWorkflows)).setter(BatchGetWorkflowsResponse.setter(Builder::missingWorkflows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingWorkflows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOWS_FIELD, MISSING_WORKFLOWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetWorkflowsResponse.memberNameToFieldInitializer();
    private final List<Workflow> workflows;
    private final List<String> missingWorkflows;

    private BatchGetWorkflowsResponse(BuilderImpl builder) {
        super(builder);
        this.workflows = builder.workflows;
        this.missingWorkflows = builder.missingWorkflows;
    }

    public final boolean hasWorkflows() {
        return this.workflows != null && !(this.workflows instanceof SdkAutoConstructList);
    }

    public final List<Workflow> workflows() {
        return this.workflows;
    }

    public final boolean hasMissingWorkflows() {
        return this.missingWorkflows != null && !(this.missingWorkflows instanceof SdkAutoConstructList);
    }

    public final List<String> missingWorkflows() {
        return this.missingWorkflows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflows() ? this.workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMissingWorkflows() ? this.missingWorkflows() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetWorkflowsResponse)) {
            return false;
        }
        BatchGetWorkflowsResponse other = (BatchGetWorkflowsResponse)((Object)obj);
        return this.hasWorkflows() == other.hasWorkflows() && Objects.equals(this.workflows(), other.workflows()) && this.hasMissingWorkflows() == other.hasMissingWorkflows() && Objects.equals(this.missingWorkflows(), other.missingWorkflows());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetWorkflowsResponse").add("Workflows", this.hasWorkflows() ? this.workflows() : null).add("MissingWorkflows", this.hasMissingWorkflows() ? this.missingWorkflows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Workflows": {
                return Optional.ofNullable(clazz.cast(this.workflows()));
            }
            case "MissingWorkflows": {
                return Optional.ofNullable(clazz.cast(this.missingWorkflows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Workflows", WORKFLOWS_FIELD);
        map.put("MissingWorkflows", MISSING_WORKFLOWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetWorkflowsResponse, T> g) {
        return obj -> g.apply((BatchGetWorkflowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Workflow> workflows = DefaultSdkAutoConstructList.getInstance();
        private List<String> missingWorkflows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetWorkflowsResponse model) {
            super(model);
            this.workflows(model.workflows);
            this.missingWorkflows(model.missingWorkflows);
        }

        public final List<Workflow.Builder> getWorkflows() {
            List<Workflow.Builder> result = WorkflowsCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<Workflow.BuilderImpl> workflows) {
            this.workflows = WorkflowsCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<Workflow> workflows) {
            this.workflows = WorkflowsCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Workflow ... workflows) {
            this.workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<Workflow.Builder> ... workflows) {
            this.workflows(Stream.of(workflows).map(c -> (Workflow)((Workflow.Builder)Workflow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getMissingWorkflows() {
            if (this.missingWorkflows instanceof SdkAutoConstructList) {
                return null;
            }
            return this.missingWorkflows;
        }

        public final void setMissingWorkflows(Collection<String> missingWorkflows) {
            this.missingWorkflows = WorkflowNamesCopier.copy(missingWorkflows);
        }

        @Override
        public final Builder missingWorkflows(Collection<String> missingWorkflows) {
            this.missingWorkflows = WorkflowNamesCopier.copy(missingWorkflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingWorkflows(String ... missingWorkflows) {
            this.missingWorkflows(Arrays.asList(missingWorkflows));
            return this;
        }

        @Override
        public BatchGetWorkflowsResponse build() {
            return new BatchGetWorkflowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetWorkflowsResponse> {
        public Builder workflows(Collection<Workflow> var1);

        public Builder workflows(Workflow ... var1);

        public Builder workflows(Consumer<Workflow.Builder> ... var1);

        public Builder missingWorkflows(Collection<String> var1);

        public Builder missingWorkflows(String ... var1);
    }
}

