/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListTableOptimizerRunsRequest;
import software.amazon.awssdk.services.glue.model.ListTableOptimizerRunsResponse;
import software.amazon.awssdk.services.glue.model.TableOptimizerRun;

public class ListTableOptimizerRunsIterable
implements SdkIterable<ListTableOptimizerRunsResponse> {
    private final GlueClient client;
    private final ListTableOptimizerRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTableOptimizerRunsIterable(GlueClient client, ListTableOptimizerRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTableOptimizerRunsResponseFetcher();
    }

    public Iterator<ListTableOptimizerRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TableOptimizerRun> tableOptimizerRuns() {
        Function<ListTableOptimizerRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tableOptimizerRuns() != null) {
                return response.tableOptimizerRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTableOptimizerRunsResponseFetcher
    implements SyncPageFetcher<ListTableOptimizerRunsResponse> {
        private ListTableOptimizerRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListTableOptimizerRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTableOptimizerRunsResponse nextPage(ListTableOptimizerRunsResponse previousPage) {
            if (previousPage == null) {
                return ListTableOptimizerRunsIterable.this.client.listTableOptimizerRuns(ListTableOptimizerRunsIterable.this.firstRequest);
            }
            return ListTableOptimizerRunsIterable.this.client.listTableOptimizerRuns((ListTableOptimizerRunsRequest)((Object)ListTableOptimizerRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

