/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimestampFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimestampFilter> {
    private static final SdkField<Instant> RECORDED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecordedBefore").getter(TimestampFilter.getter(TimestampFilter::recordedBefore)).setter(TimestampFilter.setter(Builder::recordedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordedBefore").build()}).build();
    private static final SdkField<Instant> RECORDED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecordedAfter").getter(TimestampFilter.getter(TimestampFilter::recordedAfter)).setter(TimestampFilter.setter(Builder::recordedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordedAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDED_BEFORE_FIELD, RECORDED_AFTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant recordedBefore;
    private final Instant recordedAfter;

    private TimestampFilter(BuilderImpl builder) {
        this.recordedBefore = builder.recordedBefore;
        this.recordedAfter = builder.recordedAfter;
    }

    public final Instant recordedBefore() {
        return this.recordedBefore;
    }

    public final Instant recordedAfter() {
        return this.recordedAfter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordedAfter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestampFilter)) {
            return false;
        }
        TimestampFilter other = (TimestampFilter)obj;
        return Objects.equals(this.recordedBefore(), other.recordedBefore()) && Objects.equals(this.recordedAfter(), other.recordedAfter());
    }

    public final String toString() {
        return ToString.builder((String)"TimestampFilter").add("RecordedBefore", (Object)this.recordedBefore()).add("RecordedAfter", (Object)this.recordedAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordedBefore": {
                return Optional.ofNullable(clazz.cast(this.recordedBefore()));
            }
            case "RecordedAfter": {
                return Optional.ofNullable(clazz.cast(this.recordedAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimestampFilter, T> g) {
        return obj -> g.apply((TimestampFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant recordedBefore;
        private Instant recordedAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestampFilter model) {
            this.recordedBefore(model.recordedBefore);
            this.recordedAfter(model.recordedAfter);
        }

        public final Instant getRecordedBefore() {
            return this.recordedBefore;
        }

        public final void setRecordedBefore(Instant recordedBefore) {
            this.recordedBefore = recordedBefore;
        }

        @Override
        public final Builder recordedBefore(Instant recordedBefore) {
            this.recordedBefore = recordedBefore;
            return this;
        }

        public final Instant getRecordedAfter() {
            return this.recordedAfter;
        }

        public final void setRecordedAfter(Instant recordedAfter) {
            this.recordedAfter = recordedAfter;
        }

        @Override
        public final Builder recordedAfter(Instant recordedAfter) {
            this.recordedAfter = recordedAfter;
            return this;
        }

        public TimestampFilter build() {
            return new TimestampFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimestampFilter> {
        public Builder recordedBefore(Instant var1);

        public Builder recordedAfter(Instant var1);
    }
}

