/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ErrorDetail;
import software.amazon.awssdk.services.glue.model.ResourceAction;
import software.amazon.awssdk.services.glue.model.ResourceState;
import software.amazon.awssdk.services.glue.model.StatusDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableStatus> {
    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestedBy").getter(TableStatus.getter(TableStatus::requestedBy)).setter(TableStatus.setter(Builder::requestedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedBy").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedBy").getter(TableStatus.getter(TableStatus::updatedBy)).setter(TableStatus.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedBy").build()}).build();
    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestTime").getter(TableStatus.getter(TableStatus::requestTime)).setter(TableStatus.setter(Builder::requestTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(TableStatus.getter(TableStatus::updateTime)).setter(TableStatus.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(TableStatus.getter(TableStatus::actionAsString)).setter(TableStatus.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(TableStatus.getter(TableStatus::stateAsString)).setter(TableStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(TableStatus.getter(TableStatus::error)).setter(TableStatus.setter(Builder::error)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<StatusDetails> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Details").getter(TableStatus.getter(TableStatus::details)).setter(TableStatus.setter(Builder::details)).constructor(StatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUESTED_BY_FIELD, UPDATED_BY_FIELD, REQUEST_TIME_FIELD, UPDATE_TIME_FIELD, ACTION_FIELD, STATE_FIELD, ERROR_FIELD, DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String requestedBy;
    private final String updatedBy;
    private final Instant requestTime;
    private final Instant updateTime;
    private final String action;
    private final String state;
    private final ErrorDetail error;
    private final StatusDetails details;

    private TableStatus(BuilderImpl builder) {
        this.requestedBy = builder.requestedBy;
        this.updatedBy = builder.updatedBy;
        this.requestTime = builder.requestTime;
        this.updateTime = builder.updateTime;
        this.action = builder.action;
        this.state = builder.state;
        this.error = builder.error;
        this.details = builder.details;
    }

    public final String requestedBy() {
        return this.requestedBy;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final Instant requestTime() {
        return this.requestTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final ResourceAction action() {
        return ResourceAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final ResourceState state() {
        return ResourceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final ErrorDetail error() {
        return this.error;
    }

    public final StatusDetails details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableStatus)) {
            return false;
        }
        TableStatus other = (TableStatus)obj;
        return Objects.equals(this.requestedBy(), other.requestedBy()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.requestTime(), other.requestTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.details(), other.details());
    }

    public final String toString() {
        return ToString.builder((String)"TableStatus").add("RequestedBy", (Object)this.requestedBy()).add("UpdatedBy", (Object)this.updatedBy()).add("RequestTime", (Object)this.requestTime()).add("UpdateTime", (Object)this.updateTime()).add("Action", (Object)this.actionAsString()).add("State", (Object)this.stateAsString()).add("Error", (Object)this.error()).add("Details", (Object)this.details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestedBy": {
                return Optional.ofNullable(clazz.cast(this.requestedBy()));
            }
            case "UpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "RequestTime": {
                return Optional.ofNullable(clazz.cast(this.requestTime()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableStatus, T> g) {
        return obj -> g.apply((TableStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String requestedBy;
        private String updatedBy;
        private Instant requestTime;
        private Instant updateTime;
        private String action;
        private String state;
        private ErrorDetail error;
        private StatusDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(TableStatus model) {
            this.requestedBy(model.requestedBy);
            this.updatedBy(model.updatedBy);
            this.requestTime(model.requestTime);
            this.updateTime(model.updateTime);
            this.action(model.action);
            this.state(model.state);
            this.error(model.error);
            this.details(model.details);
        }

        public final String getRequestedBy() {
            return this.requestedBy;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Instant getRequestTime() {
            return this.requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ResourceAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ResourceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final StatusDetails.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        public final void setDetails(StatusDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(StatusDetails details) {
            this.details = details;
            return this;
        }

        public TableStatus build() {
            return new TableStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableStatus> {
        public Builder requestedBy(String var1);

        public Builder updatedBy(String var1);

        public Builder requestTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder action(String var1);

        public Builder action(ResourceAction var1);

        public Builder state(String var1);

        public Builder state(ResourceState var1);

        public Builder error(ErrorDetail var1);

        default public Builder error(Consumer<ErrorDetail.Builder> error) {
            return this.error((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(error)).build());
        }

        public Builder details(StatusDetails var1);

        default public Builder details(Consumer<StatusDetails.Builder> details) {
            return this.details((StatusDetails)((StatusDetails.Builder)StatusDetails.builder().applyMutation(details)).build());
        }
    }
}

