/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the result of a data quality ruleset evaluation run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityRulesetEvaluationRunDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityRulesetEvaluationRunDescription.Builder, DataQualityRulesetEvaluationRunDescription> {
    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(DataQualityRulesetEvaluationRunDescription::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DataQualityRulesetEvaluationRunDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedOn").getter(getter(DataQualityRulesetEvaluationRunDescription::startedOn))
            .setter(setter(Builder::startedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(DataQualityRulesetEvaluationRunDescription::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_ID_FIELD, STATUS_FIELD,
            STARTED_ON_FIELD, DATA_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String runId;

    private final String status;

    private final Instant startedOn;

    private final DataSource dataSource;

    private DataQualityRulesetEvaluationRunDescription(BuilderImpl builder) {
        this.runId = builder.runId;
        this.status = builder.status;
        this.startedOn = builder.startedOn;
        this.dataSource = builder.dataSource;
    }

    /**
     * <p>
     * The unique run identifier associated with this run.
     * </p>
     * 
     * @return The unique run identifier associated with this run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The status for this run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for this run.
     * @see TaskStatusType
     */
    public final TaskStatusType status() {
        return TaskStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status for this run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for this run.
     * @see TaskStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the run started.
     * </p>
     * 
     * @return The date and time when the run started.
     */
    public final Instant startedOn() {
        return startedOn;
    }

    /**
     * <p>
     * The data source (an Glue table) associated with the run.
     * </p>
     * 
     * @return The data source (an Glue table) associated with the run.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityRulesetEvaluationRunDescription)) {
            return false;
        }
        DataQualityRulesetEvaluationRunDescription other = (DataQualityRulesetEvaluationRunDescription) obj;
        return Objects.equals(runId(), other.runId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startedOn(), other.startedOn()) && Objects.equals(dataSource(), other.dataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityRulesetEvaluationRunDescription").add("RunId", runId())
                .add("Status", statusAsString()).add("StartedOn", startedOn()).add("DataSource", dataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StartedOn":
            return Optional.ofNullable(clazz.cast(startedOn()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataQualityRulesetEvaluationRunDescription, T> g) {
        return obj -> g.apply((DataQualityRulesetEvaluationRunDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityRulesetEvaluationRunDescription> {
        /**
         * <p>
         * The unique run identifier associated with this run.
         * </p>
         * 
         * @param runId
         *        The unique run identifier associated with this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The status for this run.
         * </p>
         * 
         * @param status
         *        The status for this run.
         * @see TaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status for this run.
         * </p>
         * 
         * @param status
         *        The status for this run.
         * @see TaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatusType
         */
        Builder status(TaskStatusType status);

        /**
         * <p>
         * The date and time when the run started.
         * </p>
         * 
         * @param startedOn
         *        The date and time when the run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedOn(Instant startedOn);

        /**
         * <p>
         * The data source (an Glue table) associated with the run.
         * </p>
         * 
         * @param dataSource
         *        The data source (an Glue table) associated with the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The data source (an Glue table) associated with the run.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String runId;

        private String status;

        private Instant startedOn;

        private DataSource dataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityRulesetEvaluationRunDescription model) {
            runId(model.runId);
            status(model.status);
            startedOn(model.startedOn);
            dataSource(model.dataSource);
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedOn() {
            return startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public DataQualityRulesetEvaluationRunDescription build() {
            return new DataQualityRulesetEvaluationRunDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
