/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStatementsResponse extends GlueResponse implements
        ToCopyableBuilder<ListStatementsResponse.Builder, ListStatementsResponse> {
    private static final SdkField<List<Statement>> STATEMENTS_FIELD = SdkField
            .<List<Statement>> builder(MarshallingType.LIST)
            .memberName("Statements")
            .getter(getter(ListStatementsResponse::statements))
            .setter(setter(Builder::statements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Statement> builder(MarshallingType.SDK_POJO)
                                            .constructor(Statement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStatementsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Statement> statements;

    private final String nextToken;

    private ListStatementsResponse(BuilderImpl builder) {
        super(builder);
        this.statements = builder.statements;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Statements property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatements() {
        return statements != null && !(statements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the list of statements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatements} method.
     * </p>
     * 
     * @return Returns the list of statements.
     */
    public final List<Statement> statements() {
        return statements;
    }

    /**
     * <p>
     * A continuation token, if not all statements have yet been returned.
     * </p>
     * 
     * @return A continuation token, if not all statements have yet been returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStatements() ? statements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStatementsResponse)) {
            return false;
        }
        ListStatementsResponse other = (ListStatementsResponse) obj;
        return hasStatements() == other.hasStatements() && Objects.equals(statements(), other.statements())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStatementsResponse").add("Statements", hasStatements() ? statements() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statements":
            return Optional.ofNullable(clazz.cast(statements()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStatementsResponse, T> g) {
        return obj -> g.apply((ListStatementsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStatementsResponse> {
        /**
         * <p>
         * Returns the list of statements.
         * </p>
         * 
         * @param statements
         *        Returns the list of statements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(Collection<Statement> statements);

        /**
         * <p>
         * Returns the list of statements.
         * </p>
         * 
         * @param statements
         *        Returns the list of statements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statements(Statement... statements);

        /**
         * <p>
         * Returns the list of statements.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.Statement.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.Statement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.Statement.Builder#build()} is called immediately and its
         * result is passed to {@link #statements(List<Statement>)}.
         * 
         * @param statements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.Statement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statements(java.util.Collection<Statement>)
         */
        Builder statements(Consumer<Statement.Builder>... statements);

        /**
         * <p>
         * A continuation token, if not all statements have yet been returned.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if not all statements have yet been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Statement> statements = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStatementsResponse model) {
            super(model);
            statements(model.statements);
            nextToken(model.nextToken);
        }

        public final List<Statement.Builder> getStatements() {
            List<Statement.Builder> result = StatementListCopier.copyToBuilder(this.statements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatements(Collection<Statement.BuilderImpl> statements) {
            this.statements = StatementListCopier.copyFromBuilder(statements);
        }

        @Override
        public final Builder statements(Collection<Statement> statements) {
            this.statements = StatementListCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Statement... statements) {
            statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<Statement.Builder>... statements) {
            statements(Stream.of(statements).map(c -> Statement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStatementsResponse build() {
            return new ListStatementsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
