/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDataQualityRulesetEvaluationRunRequest extends GlueRequest implements
        ToCopyableBuilder<StartDataQualityRulesetEvaluationRunRequest.Builder, StartDataQualityRulesetEvaluationRunRequest> {
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(StartDataQualityRulesetEvaluationRunRequest::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(StartDataQualityRulesetEvaluationRunRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfWorkers").getter(getter(StartDataQualityRulesetEvaluationRunRequest::numberOfWorkers))
            .setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(StartDataQualityRulesetEvaluationRunRequest::timeout))
            .setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(StartDataQualityRulesetEvaluationRunRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<DataQualityEvaluationRunAdditionalRunOptions> ADDITIONAL_RUN_OPTIONS_FIELD = SdkField
            .<DataQualityEvaluationRunAdditionalRunOptions> builder(MarshallingType.SDK_POJO).memberName("AdditionalRunOptions")
            .getter(getter(StartDataQualityRulesetEvaluationRunRequest::additionalRunOptions))
            .setter(setter(Builder::additionalRunOptions)).constructor(DataQualityEvaluationRunAdditionalRunOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRunOptions").build())
            .build();

    private static final SdkField<List<String>> RULESET_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RulesetNames")
            .getter(getter(StartDataQualityRulesetEvaluationRunRequest::rulesetNames))
            .setter(setter(Builder::rulesetNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesetNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, ROLE_FIELD,
            NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, CLIENT_TOKEN_FIELD, ADDITIONAL_RUN_OPTIONS_FIELD, RULESET_NAMES_FIELD));

    private final DataSource dataSource;

    private final String role;

    private final Integer numberOfWorkers;

    private final Integer timeout;

    private final String clientToken;

    private final DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions;

    private final List<String> rulesetNames;

    private StartDataQualityRulesetEvaluationRunRequest(BuilderImpl builder) {
        super(builder);
        this.dataSource = builder.dataSource;
        this.role = builder.role;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.clientToken = builder.clientToken;
        this.additionalRunOptions = builder.additionalRunOptions;
        this.rulesetNames = builder.rulesetNames;
    }

    /**
     * <p>
     * The data source (Glue table) associated with this run.
     * </p>
     * 
     * @return The data source (Glue table) associated with this run.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * An IAM role supplied to encrypt the results of the run.
     * </p>
     * 
     * @return An IAM role supplied to encrypt the results of the run.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The number of <code>G.1X</code> workers to be used in the run. The default is 5.
     * </p>
     * 
     * @return The number of <code>G.1X</code> workers to be used in the run. The default is 5.
     */
    public final Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
     * terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     * </p>
     * 
     * @return The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
     *         terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or starting
     * multiple instances of the same resource.
     * </p>
     * 
     * @return Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or
     *         starting multiple instances of the same resource.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Additional run options you can specify for an evaluation run.
     * </p>
     * 
     * @return Additional run options you can specify for an evaluation run.
     */
    public final DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions() {
        return additionalRunOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the RulesetNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRulesetNames() {
        return rulesetNames != null && !(rulesetNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ruleset names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRulesetNames} method.
     * </p>
     * 
     * @return A list of ruleset names.
     */
    public final List<String> rulesetNames() {
        return rulesetNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(additionalRunOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasRulesetNames() ? rulesetNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDataQualityRulesetEvaluationRunRequest)) {
            return false;
        }
        StartDataQualityRulesetEvaluationRunRequest other = (StartDataQualityRulesetEvaluationRunRequest) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(role(), other.role())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(timeout(), other.timeout())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(additionalRunOptions(), other.additionalRunOptions())
                && hasRulesetNames() == other.hasRulesetNames() && Objects.equals(rulesetNames(), other.rulesetNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDataQualityRulesetEvaluationRunRequest").add("DataSource", dataSource())
                .add("Role", role()).add("NumberOfWorkers", numberOfWorkers()).add("Timeout", timeout())
                .add("ClientToken", clientToken()).add("AdditionalRunOptions", additionalRunOptions())
                .add("RulesetNames", hasRulesetNames() ? rulesetNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "AdditionalRunOptions":
            return Optional.ofNullable(clazz.cast(additionalRunOptions()));
        case "RulesetNames":
            return Optional.ofNullable(clazz.cast(rulesetNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDataQualityRulesetEvaluationRunRequest, T> g) {
        return obj -> g.apply((StartDataQualityRulesetEvaluationRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDataQualityRulesetEvaluationRunRequest> {
        /**
         * <p>
         * The data source (Glue table) associated with this run.
         * </p>
         * 
         * @param dataSource
         *        The data source (Glue table) associated with this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The data source (Glue table) associated with this run.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * An IAM role supplied to encrypt the results of the run.
         * </p>
         * 
         * @param role
         *        An IAM role supplied to encrypt the results of the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The number of <code>G.1X</code> workers to be used in the run. The default is 5.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of <code>G.1X</code> workers to be used in the run. The default is 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
         * terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
         * </p>
         * 
         * @param timeout
         *        The timeout for a run in minutes. This is the maximum time that a run can consume resources before it
         *        is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or
         * starting multiple instances of the same resource.
         * </p>
         * 
         * @param clientToken
         *        Used for idempotency and is recommended to be set to a random ID (such as a UUID) to avoid creating or
         *        starting multiple instances of the same resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Additional run options you can specify for an evaluation run.
         * </p>
         * 
         * @param additionalRunOptions
         *        Additional run options you can specify for an evaluation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions);

        /**
         * <p>
         * Additional run options you can specify for an evaluation run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataQualityEvaluationRunAdditionalRunOptions.Builder} avoiding the need to create one manually via
         * {@link DataQualityEvaluationRunAdditionalRunOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQualityEvaluationRunAdditionalRunOptions.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions)}.
         * 
         * @param additionalRunOptions
         *        a consumer that will call methods on {@link DataQualityEvaluationRunAdditionalRunOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions)
         */
        default Builder additionalRunOptions(Consumer<DataQualityEvaluationRunAdditionalRunOptions.Builder> additionalRunOptions) {
            return additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions.builder()
                    .applyMutation(additionalRunOptions).build());
        }

        /**
         * <p>
         * A list of ruleset names.
         * </p>
         * 
         * @param rulesetNames
         *        A list of ruleset names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesetNames(Collection<String> rulesetNames);

        /**
         * <p>
         * A list of ruleset names.
         * </p>
         * 
         * @param rulesetNames
         *        A list of ruleset names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesetNames(String... rulesetNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private DataSource dataSource;

        private String role;

        private Integer numberOfWorkers;

        private Integer timeout;

        private String clientToken;

        private DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions;

        private List<String> rulesetNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartDataQualityRulesetEvaluationRunRequest model) {
            super(model);
            dataSource(model.dataSource);
            role(model.role);
            numberOfWorkers(model.numberOfWorkers);
            timeout(model.timeout);
            clientToken(model.clientToken);
            additionalRunOptions(model.additionalRunOptions);
            rulesetNames(model.rulesetNames);
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DataQualityEvaluationRunAdditionalRunOptions.Builder getAdditionalRunOptions() {
            return additionalRunOptions != null ? additionalRunOptions.toBuilder() : null;
        }

        public final void setAdditionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions.BuilderImpl additionalRunOptions) {
            this.additionalRunOptions = additionalRunOptions != null ? additionalRunOptions.build() : null;
        }

        @Override
        public final Builder additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions) {
            this.additionalRunOptions = additionalRunOptions;
            return this;
        }

        public final Collection<String> getRulesetNames() {
            if (rulesetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return rulesetNames;
        }

        public final void setRulesetNames(Collection<String> rulesetNames) {
            this.rulesetNames = RulesetNamesCopier.copy(rulesetNames);
        }

        @Override
        public final Builder rulesetNames(Collection<String> rulesetNames) {
            this.rulesetNames = RulesetNamesCopier.copy(rulesetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesetNames(String... rulesetNames) {
            rulesetNames(Arrays.asList(rulesetNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDataQualityRulesetEvaluationRunRequest build() {
            return new StartDataQualityRulesetEvaluationRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
